package org.gcube.data.analysis.tabulardata.operation.data.add;

import java.util.Map;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;

public class AddColumn extends Worker {

	private CubeManager cubeManager;
	
	public AddColumn(OperationInvocation sourceInvocation,
			CubeManager cubeManager) {
		super(sourceInvocation);
		this.cubeManager = cubeManager;
	}


	private Table targetTable;
	private Column theNewColumn;
	

	@Override
	protected WorkerResult execute() throws WorkerException {
		targetTable=cubeManager.getTable(getSourceInvocation().getTargetTableId());
		theNewColumn=createColumn();
		Table resultTable=cubeManager.createTable(targetTable.getTableType()).like(targetTable, true).addColumn(theNewColumn).create();
		return new ImmutableWorkerResult(resultTable);
	}

	
	private Column createColumn(){
		Map<String,Object> params=getSourceInvocation().getParameterInstances();
		
		ColumnType colType=(ColumnType) params.get(AddColumnFactory.COLUMN_TYPE.getIdentifier());
		
		DataType dataType=null;
		if(params.containsKey(AddColumnFactory.DATA_TYPE.getIdentifier()))dataType=(DataType) params.get(AddColumnFactory.DATA_TYPE.getIdentifier());
		else dataType=colType.getDefaultDataType();
		
		LocalizedText label=null;
		if(params.containsKey(AddColumnFactory.LABEL.getIdentifier()))label=(LocalizedText) params.get(AddColumnFactory.LABEL.getIdentifier());
		else label=new ImmutableLocalizedText("New Column"); 
		
		
	}
	
}
