/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.add;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.data.add.AddColumn;
import org.gcube.data.analysis.tabulardata.operation.factories.types.TableTransformationWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.ColumnTypeParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.DataTypeParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.LocalizedTextParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

@Singleton
public class AddColumnFactory
extends TableTransformationWorkerFactory {
    private static final OperationId OPERATION_ID = new OperationId(1005L);
    public static final DataTypeParameter DATA_TYPE = new DataTypeParameter("dataType", "Data Type", "To set data type", Cardinality.OPTIONAL);
    public static final ColumnTypeParameter COLUMN_TYPE = new ColumnTypeParameter("columnType", "Column type", "The type of the new column", Cardinality.ONE);
    public static final LocalizedTextParameter LABEL = new LocalizedTextParameter("label", "label", "To set label", Cardinality.OPTIONAL);
    private static List<Parameter> parameters = Arrays.asList(COLUMN_TYPE, DATA_TYPE, LABEL);
    @Inject
    private CubeManager cubeManager;

    public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        this.checkAllowedColumnDataCombination(invocation);
        return new AddColumn(invocation, this.cubeManager);
    }

    protected String getOperationName() {
        return "Adds a column";
    }

    protected String getOperationDescription() {
        return "Adds a column to a table";
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    protected List<Parameter> getParameters() {
        return parameters;
    }

    private void checkAllowedColumnDataCombination(OperationInvocation invocation) throws InvalidInvocationException {
        throw new InvalidInvocationException(invocation, "");
    }
}

