/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.remove;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.data.remove.RemoveRowsById;
import org.gcube.data.analysis.tabulardata.operation.factories.types.TableTransformationWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.IntegerParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

@Singleton
public class RemoveRowsByIdFactory
extends TableTransformationWorkerFactory {
    public static final IntegerParameter ID_PARAMETER = new IntegerParameter("rowId", "RowId", "Selected row(s) id", new Cardinality(1, Integer.MAX_VALUE));
    private static List<Parameter> parameters = new ArrayList<Parameter>();
    private static final OperationId OPERATION_ID = new OperationId(3202L);
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;

    static {
        parameters.add((Parameter)ID_PARAMETER);
    }

    @Inject
    public RemoveRowsByIdFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
    }

    public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        return new RemoveRowsById(invocation, this.cubeManager, this.connectionProvider);
    }

    protected String getOperationDescription() {
        return "Removes selected rows";
    }

    protected String getOperationName() {
        return "Remove rows by Id";
    }

    protected List<Parameter> getParameters() {
        return parameters;
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }
}

