/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.remove;

import java.util.ArrayList;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.data.remove.RemoveRowsByIdFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;

public class RemoveRowsById
extends Worker {
    CubeManager cubeManager;
    DatabaseConnectionProvider connectionProvider;
    Table targetTable;
    ArrayList<Object> ids = new ArrayList();
    Table newTable;

    public RemoveRowsById(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
    }

    protected WorkerResult execute() throws WorkerException {
        this.retrieveParameters();
        this.updateProgress(0.1f);
        this.createNewTable();
        this.updateProgress(0.5f);
        this.removeRows();
        return new ImmutableWorkerResult(this.newTable);
    }

    private void removeRows() throws WorkerException {
        Column idColumn = (Column)this.newTable.getColumnsByType(new Class[]{IdColumnType.class}).get(0);
        String sqlCommand = "DELETE FROM " + this.newTable.getName() + " WHERE " + idColumn.getName() + " = ? ";
        try {
            SQLHelper.iteratePreparedStatementOverColumnValues((Column)idColumn, (String)sqlCommand, (DatabaseConnectionProvider)this.connectionProvider, this.ids);
        }
        catch (Exception e) {
            throw new WorkerException("Error occurred while performing deletion of selected tuples", (Throwable)e);
        }
    }

    private void createNewTable() {
        this.newTable = this.cubeManager.createTable(this.targetTable.getTableType()).like(this.targetTable, true).create();
    }

    private void retrieveParameters() {
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        for (Integer id : (Iterable)this.getSourceInvocation().getParameterInstances().get(RemoveRowsByIdFactory.ID_PARAMETER.getIdentifier())) {
            this.ids.add(id);
        }
    }
}

