/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.add;

import java.util.Map;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.factories.BaseColumnFactory;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDTypeValue;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.data.add.AddColumnFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;

public class AddColumn
extends Worker {
    private CubeManager cubeManager;
    private SQLExpressionEvaluatorFactory sqlEvaluatorFactory;
    private DatabaseConnectionProvider connectionProvider;
    private Table targetTable;
    private Column theNewColumn;
    private Table resultTable;

    public AddColumn(OperationInvocation sourceInvocation, CubeManager cubeManager, SQLExpressionEvaluatorFactory sqlEvaluatorFactory, DatabaseConnectionProvider connectionProvider) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.sqlEvaluatorFactory = sqlEvaluatorFactory;
        this.connectionProvider = connectionProvider;
    }

    protected WorkerResult execute() throws WorkerException {
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        this.theNewColumn = this.createColumn();
        this.resultTable = this.cubeManager.createTable(this.targetTable.getTableType()).like(this.targetTable, true).addColumn(this.theNewColumn).create();
        this.fillWithDefault();
        return new ImmutableWorkerResult(this.resultTable);
    }

    private Column createColumn() {
        Map params = this.getSourceInvocation().getParameterInstances();
        ColumnType colType = (ColumnType)params.get(AddColumnFactory.COLUMN_TYPE.getIdentifier());
        DataType dataType = null;
        dataType = params.containsKey(AddColumnFactory.DATA_TYPE.getIdentifier()) ? (DataType)params.get(AddColumnFactory.DATA_TYPE.getIdentifier()) : colType.getDefaultDataType();
        Object label = null;
        label = params.containsKey(AddColumnFactory.LABEL.getIdentifier()) ? (LocalizedText)params.get(AddColumnFactory.LABEL.getIdentifier()) : new ImmutableLocalizedText("New Column");
        return BaseColumnFactory.getFactory((ColumnType)colType).create((LocalizedText)label, dataType);
    }

    private void fillWithDefault() throws WorkerException {
        TDTypeValue value = this.theNewColumn.getDataType().getDefaultValue();
        String stmt = String.format("UPDATE %s SET %s = %s", this.resultTable.getName(), this.theNewColumn.getName(), this.sqlEvaluatorFactory.getEvaluator((Expression)value).evaluate());
        try {
            SQLHelper.executeSQLBatchCommands((DatabaseConnectionProvider)this.connectionProvider, (String[])new String[]{stmt});
        }
        catch (Exception e) {
            throw new WorkerException("Error occurred while executing SQL command " + stmt, (Throwable)e);
        }
    }
}

