package org.gcube.data.analysis.tabulardata.operation.data.remove;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.cube.exceptions.TableCreationException;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.RollbackWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;

public class RemoveColumnRollbackWorker extends RollbackWorker {

	private CubeManager cubeManager;	
	private DatabaseConnectionProvider connectionProvider;
		
	public RemoveColumnRollbackWorker(Table diffTable, Table resultTable, OperationInvocation oldInvocation, CubeManager cm, DatabaseConnectionProvider connectionProvider) {
		super(diffTable, resultTable, oldInvocation);
		this.cubeManager = cm;	
		this.connectionProvider = connectionProvider;
	}
	
	@SuppressWarnings("unchecked")
	@Override
	protected WorkerResult execute() throws WorkerException {
		Table tableToReturn;
		try{
			Column columnToAdd = diffTable.getColumnsExceptTypes(IdColumnType.class).get(0);
			tableToReturn = cubeManager.createTable(resultTable.getTableType()).like(resultTable, true).addColumn(columnToAdd).create();
			addDiffTableEntries(tableToReturn, columnToAdd);
		}catch(TableCreationException tce){
			throw new WorkerException("error creating return table",tce);
		}
		return new ImmutableWorkerResult(tableToReturn);
	}
	
	private void addDiffTableEntries(Table tableToReturn, Column columnAdded) throws WorkerException{
		try {
			String sqlCommand=String.format("UPDATE %1$s returnTable SET %2$s = diff.%2$s FROM %3$s as diff WHERE diff.id = returnTable.id ",
					tableToReturn.getName(), columnAdded.getName(), diffTable.getName() );			
			SQLHelper.executeSQLBatchCommands(connectionProvider, sqlCommand);
		} catch (Exception e) {
			throw new WorkerException("Error occurred while executing SQL command", e);
		}
	}
	
}
