/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.add;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.NotEvaluableDataTypeException;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.data.add.AddColumn;
import org.gcube.data.analysis.tabulardata.operation.data.add.AddColumnRollbackWorker;
import org.gcube.data.analysis.tabulardata.operation.factories.types.TableTransformationWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.ColumnTypeParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.DataTypeParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.ExpressionParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.LocalizedTextParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.RollbackWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

@Singleton
public class AddColumnFactory
extends TableTransformationWorkerFactory {
    private static final OperationId OPERATION_ID = new OperationId(1005L);
    public static final DataTypeParameter DATA_TYPE = new DataTypeParameter("dataType", "Data Type", "To set data type", Cardinality.OPTIONAL);
    public static final ColumnTypeParameter COLUMN_TYPE = new ColumnTypeParameter("columnType", "Column type", "The type of the new column", Cardinality.ONE);
    public static final LocalizedTextParameter LABEL = new LocalizedTextParameter("label", "label", "To set label", Cardinality.OPTIONAL);
    public static final ExpressionParameter VALUE_PARAMETER = new ExpressionParameter("value", "To set Value", "The value to be set in new column.", Cardinality.OPTIONAL);
    private static List<Parameter> parameters = Arrays.asList(COLUMN_TYPE, DATA_TYPE, LABEL, VALUE_PARAMETER);
    @Inject
    private CubeManager cubeManager;
    @Inject
    private SQLExpressionEvaluatorFactory sqlEvaluatorFactory;
    @Inject
    private DatabaseConnectionProvider connectionProvider;

    public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        this.checkAllowedColumnDataCombination(invocation);
        return new AddColumn(invocation, this.cubeManager, this.sqlEvaluatorFactory, this.connectionProvider);
    }

    public boolean isRollbackable() {
        return true;
    }

    public RollbackWorker createRollbackWoker(Table diffTable, Table createdTable, OperationInvocation oldInvocation) {
        return new AddColumnRollbackWorker(diffTable, createdTable, oldInvocation, this.cubeManager);
    }

    protected String getOperationName() {
        return "Adds a column";
    }

    protected String getOperationDescription() {
        return "Adds a column to a table";
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    protected List<Parameter> getParameters() {
        return parameters;
    }

    private void checkAllowedColumnDataCombination(OperationInvocation invocation) throws InvalidInvocationException {
        Expression expr;
        DataType type;
        TableType tableType = this.cubeManager.getTable(invocation.getTargetTableId()).getTableType();
        Map params = invocation.getParameterInstances();
        ColumnType colType = (ColumnType)params.get(COLUMN_TYPE.getIdentifier());
        if (colType.equals((Object)new ValidationColumnType()) || colType.equals((Object)new IdColumnType())) {
            throw new InvalidInvocationException(invocation, String.format("Column type %s cannot be added by user", colType.getName()));
        }
        if (!tableType.getAllowedColumnTypes().contains(colType)) {
            throw new InvalidInvocationException(invocation, String.format("Passed column type %s is not allowed for target table type %s. Allowed types are %s.", colType.getName(), tableType.getName(), tableType.getAllowedColumnTypes()));
        }
        DataType dataType = type = params.containsKey(DATA_TYPE.getIdentifier()) ? (DataType)params.get(DATA_TYPE.getIdentifier()) : null;
        if (type != null) {
            if (!colType.isDataTypeAllowed(type)) {
                throw new InvalidInvocationException(invocation, String.format("Incompatible column type %s and data type %s. Allowed data types are %s.", colType.getName(), type.getName(), colType.getAllowedDataTypes()));
            }
        } else {
            type = colType.getDefaultDataType();
        }
        Expression expression = expr = params.containsKey(VALUE_PARAMETER.getIdentifier()) ? (Expression)params.get(VALUE_PARAMETER.getIdentifier()) : null;
        if (expr != null) {
            try {
                DataType exprType = expr.getReturnedDataType();
                if (!type.getName().equals(exprType.getName())) {
                    throw new InvalidInvocationException(invocation, String.format("Incompatible target type %s and value type %s. Allowed data types are %s.", type.getName(), exprType.getName(), colType.getAllowedDataTypes()));
                }
            }
            catch (NotEvaluableDataTypeException notEvaluableDataTypeException) {
                // empty catch block
            }
        }
    }

    public String describeInvocation(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        this.checkAllowedColumnDataCombination(invocation);
        ColumnType colType = (ColumnType)OperationHelper.getParameter((LeafParameter)COLUMN_TYPE, (OperationInvocation)invocation);
        DataType dataType = colType.getDefaultDataType();
        if (invocation.getParameterInstances().containsKey(DATA_TYPE.getIdentifier())) {
            dataType = (DataType)OperationHelper.getParameter((LeafParameter)DATA_TYPE, (OperationInvocation)invocation);
        }
        if (invocation.getParameterInstances().containsKey(LABEL.getIdentifier())) {
            LocalizedText label = (LocalizedText)OperationHelper.getParameter((LeafParameter)LABEL, (OperationInvocation)invocation);
            return String.format("Add %s (%s) with label %s[%s] ", colType.getName(), dataType, label.getValue(), label.getLocale());
        }
        return String.format("Add %s (%s)", colType.getName(), dataType);
    }
}

