/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.add;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.cube.exceptions.TableCreationException;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.RollbackWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;

public class AddRowRollbackWorker
extends RollbackWorker {
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;

    public AddRowRollbackWorker(Table diffTable, Table resultTable, OperationInvocation oldInvocation, CubeManager cm, DatabaseConnectionProvider connectionProvider) {
        super(diffTable, resultTable, oldInvocation);
        this.cubeManager = cm;
        this.connectionProvider = connectionProvider;
    }

    protected WorkerResult execute() throws WorkerException {
        Table tableToReturn;
        try {
            tableToReturn = this.cubeManager.createTable(this.resultTable.getTableType()).like(this.resultTable, true).create();
        }
        catch (TableCreationException tce) {
            throw new WorkerException("error creating return table", (Throwable)tce);
        }
        this.addDiffTableEntries(tableToReturn);
        return new ImmutableWorkerResult(tableToReturn);
    }

    private void addDiffTableEntries(Table tableToReturn) throws WorkerException {
        try {
            String sqlCommand = String.format("DELETE FROM %s as result USING %s as diff WHERE result.id = diff.id ", tableToReturn.getName(), this.diffTable.getName());
            SQLHelper.executeSQLBatchCommands((DatabaseConnectionProvider)this.connectionProvider, (String[])new String[]{sqlCommand});
        }
        catch (Exception e) {
            throw new WorkerException("Error occurred while executing SQL command", (Throwable)e);
        }
    }
}

