/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.add;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDTypeValue;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.data.add.AddRowFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;

public class AddRow
extends Worker {
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private SQLExpressionEvaluatorFactory sqlEvaluatorFactory;
    private Table diffTable;
    private Table targetTable;
    private Table resultTable;
    private Map<Column, TDTypeValue> newRowValues;

    public AddRow(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory sqlEvaluatorFactory) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.sqlEvaluatorFactory = sqlEvaluatorFactory;
    }

    protected WorkerResult execute() throws WorkerException {
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        this.updateProgress(0.1f, "Initializing");
        this.initToAddRow();
        this.updateProgress(0.2f, "Creating data");
        this.resultTable = this.cubeManager.createTable(this.targetTable.getTableType()).like(this.targetTable, true).create();
        this.diffTable = this.cubeManager.createTable(this.targetTable.getTableType()).like(this.targetTable, false, this.targetTable.getColumnsExceptTypes(new Class[]{IdColumnType.class})).create();
        this.insertRow();
        this.updateProgress(0.9f, "Finalizing");
        return new ImmutableWorkerResult(this.resultTable, this.diffTable);
    }

    private void initToAddRow() {
        HashMap<ColumnLocalId, TDTypeValue> specifiedMappings = new HashMap<ColumnLocalId, TDTypeValue>();
        for (Map<String, Object> specifiedMapping : AddRowFactory.getMapping(this.getSourceInvocation())) {
            ColumnLocalId id = ((ColumnReference)specifiedMapping.get(AddRowFactory.columnParam.getIdentifier())).getColumnId();
            TDTypeValue value = (TDTypeValue)specifiedMapping.get(AddRowFactory.toSetValue.getIdentifier());
            specifiedMappings.put(id, value);
        }
        this.newRowValues = new HashMap<Column, TDTypeValue>();
        Iterator<Map<String, Object>> i$ = this.targetTable.getColumnsExceptTypes(new Class[]{IdColumnType.class}).iterator();
        while (i$.hasNext()) {
            Column col;
            this.newRowValues.put(col, specifiedMappings.containsKey((col = (Column)i$.next()).getLocalId()) ? (TDTypeValue)specifiedMappings.get(col.getLocalId()) : col.getDataType().getDefaultValue());
        }
    }

    private void insertRow() throws WorkerException {
        String columnNameSnippet = OperationHelper.getColumnNamesSnippet(this.newRowValues.keySet());
        String valueSnippet = this.getValueSnippet(this.newRowValues.values());
        String sqlCommand = String.format("WITH inserted AS (INSERT INTO %s (%s) values (%s) RETURNING * )  INSERT INTO %s (id) SELECT id FROM inserted", this.resultTable.getName(), columnNameSnippet, valueSnippet, this.diffTable.getName());
        try {
            SQLHelper.executeSQLBatchCommands((DatabaseConnectionProvider)this.connectionProvider, (String[])new String[]{sqlCommand});
        }
        catch (Exception e) {
            throw new WorkerException("Error occurred while executing SQL command", (Throwable)e);
        }
    }

    private String getValueSnippet(Collection<TDTypeValue> values) {
        StringBuilder snippet = new StringBuilder();
        for (TDTypeValue value : values) {
            snippet.append((String)this.sqlEvaluatorFactory.getEvaluator((Expression)value).evaluate() + ", ");
        }
        snippet.delete(snippet.length() - 2, snippet.length() - 1);
        return snippet.toString();
    }
}

