/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.add;

import java.sql.SQLException;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.RollbackWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;

public class UnionRollbackWorker
extends RollbackWorker {
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;

    public UnionRollbackWorker(Table diffTable, Table resultTable, OperationInvocation oldInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
        super(diffTable, resultTable, oldInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
    }

    protected WorkerResult execute() throws WorkerException {
        this.updateProgress(0.1f, "Initialized");
        Table toReturnTable = this.cubeManager.createTable(this.resultTable.getTableType()).like(this.resultTable, true).create();
        this.updateProgress(0.5f, "Removing imported rows");
        String query = String.format("DELETE FROM %s where id IN (SELECT id from %s)", toReturnTable.getName(), this.diffTable.getName());
        try {
            SQLHelper.executeSQLCommand((String)query, (DatabaseConnectionProvider)this.connectionProvider);
            this.updateProgress(0.9f, "Finalizing");
            return new ImmutableWorkerResult(toReturnTable);
        }
        catch (SQLException e) {
            throw new WorkerException("Unable to rollback", (Throwable)e);
        }
    }
}

