/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.replace;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.cube.exceptions.TableCreationException;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.RollbackWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;

public class ReplaceRollbackWorker
extends RollbackWorker {
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;

    public ReplaceRollbackWorker(Table diffTable, Table resultTable, OperationInvocation oldInvocation, CubeManager cm, DatabaseConnectionProvider connectionProvider) {
        super(diffTable, resultTable, oldInvocation);
        this.cubeManager = cm;
        this.connectionProvider = connectionProvider;
    }

    protected WorkerResult execute() throws WorkerException {
        Table tableToReturn;
        this.updateProgress(0.1f, "Preparing table");
        try {
            tableToReturn = this.cubeManager.createTable(this.resultTable.getTableType()).like(this.resultTable, true).create();
        }
        catch (TableCreationException tce) {
            throw new WorkerException("error creating return table", (Throwable)tce);
        }
        this.updateProgress(0.3f, "Filling table with saved data");
        this.addDiffTableEntries(tableToReturn);
        return new ImmutableWorkerResult(tableToReturn);
    }

    private void addDiffTableEntries(Table tableToReturn) throws WorkerException {
        try {
            Column targetColumn = (Column)this.diffTable.getColumnsExceptTypes(new Class[]{IdColumnType.class}).get(0);
            String sqlCommand = String.format("UPDATE %1$s AS result SET %2$s = diff.%2$s FROM %3$s AS diff WHERE result.id = diff.id ", tableToReturn.getName(), targetColumn.getName(), this.diffTable.getName());
            SQLHelper.executeSQLBatchCommands((DatabaseConnectionProvider)this.connectionProvider, (String[])new String[]{sqlCommand});
        }
        catch (Exception e) {
            throw new WorkerException("Error occurred while executing SQL command", (Throwable)e);
        }
    }
}

