package org.gcube.data.analysis.tabulardata.operation.data.transformation;

import java.util.Collections;
import java.util.Map;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.factories.CodeColumnFactory;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.type.CodelistTableType;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;

public class ExtractCodelist extends DataWorker {

	CubeManager cubeManager;
	
	DatabaseConnectionProvider connectionProvider;
	
	
	public ExtractCodelist(OperationInvocation sourceInvocation,
			CubeManager cubeManager,
			DatabaseConnectionProvider connectionProvider) {
		super(sourceInvocation);
		this.cubeManager = cubeManager;
		this.connectionProvider = connectionProvider;
	}
	
	
	
	
	private Column sourceColumn;
	private Column targetCodeColumn;	
	private Table sourceTable;
	private Table targetCodelist;
	
	
	
	@Override
	protected WorkerResult execute() throws WorkerException {
		updateProgress(0.1f,"Initializing");
		initialize();
		updateProgress(0.3f,"Inserting values into destination codelist");
		insertData();
		return new ImmutableWorkerResult(sourceTable, Collections.singletonList(targetCodelist));
	}

	
	private void initialize()throws WorkerException{
		OperationInvocation invocation=getSourceInvocation();
		Map<String,Object> params=invocation.getParameterInstances();
		sourceTable=cubeManager.getTable(invocation.getTargetTableId());
		sourceColumn=sourceTable.getColumnById(((ColumnReference)params.get(ExtractCodelistFactory.VALUES_SOURCE_COLUMN.getIdentifier())).getColumnId());
		if(params.containsKey(ExtractCodelistFactory.TARGET_CODE_COLUMN.getIdentifier())){
			// specified target codelist
			ColumnReference ref=(ColumnReference) params.get(ExtractCodelistFactory.TARGET_CODE_COLUMN.getIdentifier());
			Table selectedCodelist=cubeManager.getTable(ref.getTableId());
			Column selectedCodeColumn=selectedCodelist.getColumnById(ref.getColumnId());
			targetCodelist=cubeManager.createTable(new CodelistTableType()).like(selectedCodelist, true).create();			
			targetCodeColumn=targetCodelist.getColumnById(ref.getColumnId());
		}else {
			//new codelist
			targetCodeColumn =new CodeColumnFactory().createDefault();
			targetCodelist=cubeManager.createTable(new CodelistTableType()).addColumn(targetCodeColumn).create();
		}
	}
	
	private void insertData() throws WorkerException{
		String selectCmd=String.format("SELECT distinct(%s) as %s FROM %s",sourceColumn.getName(),targetCodeColumn.getName(),sourceTable.getName());
		String insertCmd=String.format("INSERT INTO %s (%s) (%s)", targetCodelist.getName(),targetCodeColumn.getName(),selectCmd);
		try{
			SQLHelper.executeSQLCommand(insertCmd, connectionProvider);
		}catch(Exception e){
			throw new WorkerException("Error occurred while performing insert query", e);
		}
	}
}
