/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.add;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.expression.functions.Cast;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.model.table.type.GenericTableType;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.data.add.UnionFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;

public class UnionWorker
extends DataWorker {
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private SQLExpressionEvaluatorFactory evaluatorFactory;
    private Table targetTable = null;
    private Table sourceTable = null;
    private Table resultTable = null;
    private Table diffTable = null;
    private Map<Column, Column> colMappings = new HashMap<Column, Column>();
    private String insertQuery = null;

    public UnionWorker(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory evaluatorFactory) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.evaluatorFactory = evaluatorFactory;
    }

    protected WorkerResult execute() throws WorkerException {
        this.init();
        this.updateProgress(0.1f, "Initialized process");
        this.resultTable = this.cubeManager.createTable(this.targetTable.getTableType()).like(this.targetTable, true).create();
        this.diffTable = this.cubeManager.createTable((TableType)new GenericTableType()).create();
        this.updateProgress(0.5f, "Importing data");
        this.formQueries();
        try {
            SQLHelper.executeSQLCommand((String)this.insertQuery, (DatabaseConnectionProvider)this.connectionProvider);
            this.updateProgress(0.9f, "Finalizing data");
            return new ImmutableWorkerResult(this.resultTable, this.diffTable);
        }
        catch (SQLException e) {
            throw new WorkerException("Unable to execute queries", (Throwable)e);
        }
    }

    private void init() {
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        List<Map<String, Object>> mappings = UnionFactory.getMappings(this.getSourceInvocation());
        for (Map<String, Object> mapping : mappings) {
            ColumnReference sourceRef = (ColumnReference)mapping.get(UnionFactory.SOURCE_COLUMN_PARAMETER.getIdentifier());
            if (this.sourceTable == null) {
                this.sourceTable = this.cubeManager.getTable(sourceRef.getTableId());
            }
            ColumnReference targetRef = (ColumnReference)mapping.get(UnionFactory.TARGET_COLUMN_PARAMETER.getIdentifier());
            Column sourceCol = this.sourceTable.getColumnById(sourceRef.getColumnId());
            Column targetCol = this.targetTable.getColumnById(targetRef.getColumnId());
            this.colMappings.put(targetCol, sourceCol);
        }
    }

    private void formQueries() {
        StringBuilder selectionSnippet = new StringBuilder();
        StringBuilder targetFieldsSnippet = new StringBuilder();
        for (Column col : this.resultTable.getColumnsExceptTypes(new Class[]{IdColumnType.class})) {
            targetFieldsSnippet.append(col.getName() + ",");
            if (!this.colMappings.containsKey(col)) {
                selectionSnippet.append((String)this.evaluatorFactory.getEvaluator((Expression)col.getDataType().getDefaultValue()).evaluate() + ",");
                continue;
            }
            Column source = this.colMappings.get(col);
            DataType targetDataType = source.getDataType();
            selectionSnippet.append((String)this.evaluatorFactory.getEvaluator((Expression)new Cast((Expression)this.sourceTable.getColumnReference(source), targetDataType)).evaluate() + ",");
        }
        selectionSnippet.deleteCharAt(selectionSnippet.lastIndexOf(","));
        targetFieldsSnippet.deleteCharAt(targetFieldsSnippet.lastIndexOf(","));
        this.insertQuery = String.format("WITH inserted AS (INSERT INTO %s(%s) SELECT %s from %s RETURNING *) INSERT INTO %s(id) SELECT id from inserted", this.resultTable.getName(), targetFieldsSnippet.toString(), selectionSnippet.toString(), this.sourceTable.getName(), this.diffTable.getName());
    }
}

