/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.replace;

import java.util.HashMap;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.MalformedExpressionException;
import org.gcube.data.analysis.tabulardata.expression.TableReferenceReplacer;
import org.gcube.data.analysis.tabulardata.expression.evaluator.EvaluatorException;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDTypeValue;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.data.add.AddRowFactory;
import org.gcube.data.analysis.tabulardata.operation.data.replace.ReplaceRowByExpressionFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;

public class ReplaceRowWorker
extends DataWorker {
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private SQLExpressionEvaluatorFactory sqlEvaluatorFactory;
    private Table targetTable;
    private Table resultTable;
    private Map<Column, TDTypeValue> newRowValues = new HashMap<Column, TDTypeValue>();
    private Expression condition;
    private Table diffTable;

    public ReplaceRowWorker(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory sqlEvaluatorFactory) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.sqlEvaluatorFactory = sqlEvaluatorFactory;
    }

    protected WorkerResult execute() throws WorkerException {
        this.updateProgress(0.1f, "Initializing");
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        this.instantiateExecutionVariables();
        this.diffTable = this.cubeManager.createTable(this.targetTable.getTableType()).like(this.targetTable, false).create();
        this.resultTable = this.cubeManager.createTable(this.targetTable.getTableType()).like(this.targetTable, true).create();
        this.updateProgress(0.5f, "Updating");
        this.executeBatch();
        this.updateProgress(0.9f, "Finalizing");
        return new ImmutableWorkerResult(this.resultTable, this.diffTable);
    }

    private void instantiateExecutionVariables() throws WorkerException {
        OperationInvocation invocation = this.getSourceInvocation();
        this.condition = (Expression)invocation.getParameterInstances().get(ReplaceRowByExpressionFactory.CONDITION_PARAMETER.getIdentifier());
        for (Map<String, Object> specifiedMapping : ReplaceRowByExpressionFactory.getMapping(this.getSourceInvocation())) {
            ColumnLocalId id = ((ColumnReference)specifiedMapping.get(AddRowFactory.columnParam.getIdentifier())).getColumnId();
            TDTypeValue value = (TDTypeValue)specifiedMapping.get(AddRowFactory.toSetValue.getIdentifier());
            Column col = this.targetTable.getColumnById(id);
            this.newRowValues.put(col, value);
        }
    }

    private void executeBatch() throws WorkerException {
        try {
            SQLHelper.executeSQLBatchCommands((DatabaseConnectionProvider)this.connectionProvider, (String[])new String[]{this.getUpdateStatement()});
        }
        catch (Exception e) {
            throw new WorkerException("Error occurred while executing SQL command", (Throwable)e);
        }
    }

    private String getUpdateStatement() throws WorkerException {
        try {
            Expression actualCondition = this.updateTableReferences(this.condition);
            StringBuilder setSnippet = new StringBuilder();
            for (Map.Entry<Column, TDTypeValue> entry : this.newRowValues.entrySet()) {
                setSnippet.append(String.format("%s = %s,", entry.getKey().getName(), this.sqlEvaluatorFactory.getEvaluator((Expression)entry.getValue()).evaluate()));
            }
            setSnippet.deleteCharAt(setSnippet.lastIndexOf(","));
            String stmt = String.format("WITH toUpdate AS (INSERT INTO %1$s SELECT * FROM %2$s WHERE %3$s RETURNING id)  UPDATE %2$s SET %4$s WHERE id in (Select id from toUpdate)", this.diffTable.getName(), this.resultTable.getName(), this.sqlEvaluatorFactory.getEvaluator(actualCondition).evaluate(), setSnippet);
            return stmt;
        }
        catch (MalformedExpressionException e) {
            throw new WorkerException("Expression is not well formed", (Throwable)e);
        }
        catch (EvaluatorException e) {
            throw new WorkerException("Unable to evaluate expression", (Throwable)e);
        }
    }

    private Expression updateTableReferences(Expression e) throws MalformedExpressionException {
        TableReferenceReplacer replacer = new TableReferenceReplacer(e);
        for (ColumnReference original : replacer.getReferences(this.targetTable.getId())) {
            String columnName = this.targetTable.getColumnById(original.getColumnId()).getName();
            replacer.replaceColumnReference(original, (ColumnReference)this.resultTable.getColumnReference(this.resultTable.getColumnByName(columnName)));
        }
        return replacer.getExpression();
    }
}

