/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.replace;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.evaluator.description.DescriptionExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.data.replace.ReplaceByExpression;
import org.gcube.data.analysis.tabulardata.operation.data.replace.ReplaceRollbackWorker;
import org.gcube.data.analysis.tabulardata.operation.factories.types.ColumnTransformationWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.ExpressionParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.types.RollbackWorker;

@Singleton
public class ReplaceByExpressionFactory
extends ColumnTransformationWorkerFactory {
    private static final OperationId OPERATION_ID = new OperationId(3101L);
    public static final ExpressionParameter CONDITION_PARAMETER = new ExpressionParameter("condition", "Condition", "Boolean condition that identifies to modify rows", Cardinality.OPTIONAL);
    public static final ExpressionParameter VALUE_PARAMETER = new ExpressionParameter("value", "Value", "Expression that returns the value to be set", Cardinality.ONE);
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private SQLExpressionEvaluatorFactory sqlEvaluatorFactory;
    private DescriptionExpressionEvaluatorFactory descriptionEvaluatorFactory;

    @Inject
    public ReplaceByExpressionFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory sqlEvaluatorFactory, DescriptionExpressionEvaluatorFactory descriptionEvaluatorFactory) {
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.sqlEvaluatorFactory = sqlEvaluatorFactory;
        this.descriptionEvaluatorFactory = descriptionEvaluatorFactory;
    }

    public DataWorker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        return new ReplaceByExpression(invocation, this.cubeManager, this.connectionProvider, this.sqlEvaluatorFactory);
    }

    public boolean isRollbackable() {
        return true;
    }

    public RollbackWorker createRollbackWoker(Table diffTable, Table createdTable, OperationInvocation oldInvocation) {
        return new ReplaceRollbackWorker(diffTable, createdTable, oldInvocation, this.cubeManager, this.connectionProvider);
    }

    protected String getOperationDescription() {
        return "Updates the values of the selected column in rows matching the defined condition";
    }

    protected String getOperationName() {
        return "Replace By Expression";
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    protected List<Parameter> getParameters() {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add((Parameter)CONDITION_PARAMETER);
        parameters.add((Parameter)VALUE_PARAMETER);
        return parameters;
    }

    public String describeInvocation(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        Expression condition = null;
        try {
            condition = (Expression)OperationHelper.getParameter((LeafParameter)CONDITION_PARAMETER, (OperationInvocation)invocation);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Expression value = (Expression)OperationHelper.getParameter((LeafParameter)VALUE_PARAMETER, (OperationInvocation)invocation);
        Column col = this.cubeManager.getTable(invocation.getTargetTableId()).getColumnById(invocation.getTargetColumnId());
        if (condition != null) {
            return String.format("Set %s = %s where %s", OperationHelper.retrieveColumnLabel((Column)col), this.descriptionEvaluatorFactory.getEvaluator(value).evaluate(), this.descriptionEvaluatorFactory.getEvaluator(condition).evaluate());
        }
        return String.format("Set %s = %s", OperationHelper.retrieveColumnLabel((Column)col), this.descriptionEvaluatorFactory.getEvaluator(value).evaluate());
    }
}

