/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.transformation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.data.transformation.NormalizationWorker;
import org.gcube.data.analysis.tabulardata.operation.factories.types.TableTransformationWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.LocalizedTextParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.TargetColumnParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;

@Singleton
public class NormalizationFactory
extends TableTransformationWorkerFactory {
    private static final OperationId OPERATION_ID = new OperationId(3008L);
    public static TargetColumnParameter TO_NORMALIZE_COLUMNS = new TargetColumnParameter("to_normalize", "To normalize", "Columns to normalize", new Cardinality(1, Integer.MAX_VALUE));
    public static final LocalizedTextParameter NORMALIZED_LABEL = new LocalizedTextParameter("norm_label", "Normalized label", "The normalized column label", Cardinality.OPTIONAL);
    public static final LocalizedTextParameter QUANTITY_LABEL = new LocalizedTextParameter("quant_label", "Quantity label", "The quantity column label", Cardinality.OPTIONAL);
    private static List<Parameter> params = Arrays.asList(TO_NORMALIZE_COLUMNS, NORMALIZED_LABEL, QUANTITY_LABEL);
    private CubeManager cubeManager;
    private SQLExpressionEvaluatorFactory evaluatorFactory;
    private DatabaseConnectionProvider connProvider;

    @Inject
    public NormalizationFactory(CubeManager cubeManager, SQLExpressionEvaluatorFactory evaluatorFactory, DatabaseConnectionProvider connProvider) {
        this.cubeManager = cubeManager;
        this.evaluatorFactory = evaluatorFactory;
        this.connProvider = connProvider;
    }

    public DataWorker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        this.performCustomChecks(invocation);
        return new NormalizationWorker(invocation, this.cubeManager, this.evaluatorFactory, this.connProvider);
    }

    private void performCustomChecks(OperationInvocation toDescribeInvocation) throws InvalidInvocationException {
        for (ColumnReference ref : NormalizationFactory.getColumns(toDescribeInvocation)) {
            if (ref.getTableId().equals((Object)toDescribeInvocation.getTargetTableId())) continue;
            throw new InvalidInvocationException(toDescribeInvocation, "All column must belong to target table");
        }
    }

    static List<ColumnReference> getColumns(OperationInvocation invocation) throws InvalidInvocationException {
        try {
            ArrayList<ColumnReference> toReturn = new ArrayList<ColumnReference>();
            Object value = invocation.getParameterInstances().get(TO_NORMALIZE_COLUMNS.getIdentifier());
            if (value instanceof Iterable) {
                for (ColumnReference ref : (Iterable)value) {
                    toReturn.add(ref);
                }
            } else {
                toReturn.add((ColumnReference)value);
            }
            return toReturn;
        }
        catch (Exception e) {
            throw new InvalidInvocationException(invocation, e);
        }
    }

    public String describeInvocation(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        this.performCustomChecks(invocation);
        ArrayList<Column> toNormalize = new ArrayList<Column>();
        Table target = this.cubeManager.getTable(invocation.getTargetTableId());
        for (ColumnReference ref : NormalizationFactory.getColumns(invocation)) {
            toNormalize.add(target.getColumnById(ref.getColumnId()));
        }
        return String.format("Normalize %s", OperationHelper.getColumnLabelsSnippet(toNormalize));
    }

    protected String getOperationName() {
        return "Normalize";
    }

    protected String getOperationDescription() {
        return "Normalize columns";
    }

    protected List<Parameter> getParameters() {
        return params;
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }
}

