/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.labels;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.exceptions.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableMetaCreator;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.exceptions.NoSuchColumnException;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.DatasetViewTableMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.labels.AddColumnNameFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.EmptyType;
import org.gcube.data.analysis.tabulardata.operation.worker.types.MetadataWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddColumnName
extends MetadataWorker {
    private static final Logger log = LoggerFactory.getLogger(AddColumnName.class);
    private CubeManager cubeManager;
    private Map<ColumnReference, LocalizedText> namesToSet = null;

    public AddColumnName(CubeManager cubeManager, OperationInvocation Invocation) {
        super(Invocation);
        this.cubeManager = cubeManager;
    }

    protected EmptyType execute() throws WorkerException {
        this.retrieveNameToSet();
        this.updateProgress(0.3f, "Adding label metadata");
        Table table = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        this.createTableWithNewColumnLabels(table.getId());
        this.updateProgress(0.6f, "Changing labels on view");
        if (table.contains(DatasetViewTableMetadata.class)) {
            TableId viewId = ((DatasetViewTableMetadata)table.getMetadata(DatasetViewTableMetadata.class)).getTargetDatasetViewTableId();
            this.createTableWithNewColumnLabels(viewId);
        }
        return EmptyType.instance();
    }

    private void retrieveNameToSet() {
        this.namesToSet = (Map)this.getSourceInvocation().getParameterInstances().get(AddColumnNameFactory.NAME_LABEL_PARAMETER.getIdentifier());
    }

    private Table createTableWithNewColumnLabels(TableId tableId) {
        TableMetaCreator tmc = this.cubeManager.modifyTableMeta(tableId);
        for (Map.Entry<ColumnReference, LocalizedText> entry : this.namesToSet.entrySet()) {
            NamesMetadata oldNamesMetadata = this.getOldNamesMetadata(entry.getKey().getColumnId());
            List oldTexts = oldNamesMetadata.getTexts();
            ArrayList<LocalizedText> newTexts = new ArrayList<LocalizedText>();
            for (LocalizedText existent : oldTexts) {
                if (existent.getLocale().equalsIgnoreCase(entry.getValue().getLocale())) continue;
                newTexts.add(existent);
            }
            newTexts.add(entry.getValue());
            log.debug("Setting names for col with id " + entry.getKey().getColumnId() + ": " + newTexts);
            NamesMetadata newNamesMetadata = new NamesMetadata(newTexts);
            tmc.setColumnMetadata(entry.getKey().getColumnId(), new ColumnMetadata[]{newNamesMetadata});
        }
        return tmc.create();
    }

    private NamesMetadata getOldNamesMetadata(ColumnLocalId columnId) {
        try {
            return (NamesMetadata)this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId()).getColumnById(columnId).getMetadata(NamesMetadata.class);
        }
        catch (NoSuchColumnException e) {
            throw new RuntimeException("Provided target column id does not exist");
        }
        catch (NoSuchTableException e) {
            throw new RuntimeException("Provided target table id does not exist");
        }
        catch (NoSuchMetadataException e) {
            return new NamesMetadata(new ArrayList());
        }
    }
}

