package org.gcube.data.analysis.tabulardata.operation.column.typechange;

import java.util.List;

import javax.inject.Inject;
import javax.inject.Singleton;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AnnotationColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeDescriptionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeNameColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.MeasureColumnType;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.LocalizedTextParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

import com.google.common.collect.Lists;

@Singleton
public class ChangeToAttributeColumnFactory extends ChangeColumnTypeTransformationFactory {

	private static final AttributeColumnType MANAGED_COLUMN_TYPE = new AttributeColumnType();

	public static final String LABEL_ID = "label";

	public final static List<Class<? extends ColumnType>> allowedSourceColumnTypes = Lists.newArrayList();

	private DatabaseConnectionProvider connectionProvider;

	static {
		allowedSourceColumnTypes.add(AnnotationColumnType.class);
		allowedSourceColumnTypes.add(AttributeColumnType.class);
		allowedSourceColumnTypes.add(CodeColumnType.class);
		allowedSourceColumnTypes.add(CodeNameColumnType.class);
		allowedSourceColumnTypes.add(CodeDescriptionColumnType.class);
		allowedSourceColumnTypes.add(MeasureColumnType.class);
	}

	@Inject
	public ChangeToAttributeColumnFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
		super(cubeManager);
		this.connectionProvider = connectionProvider;
	}

	@Override
	protected ColumnType getManagedColumnType() {
		return MANAGED_COLUMN_TYPE;
	}

	@Override
	protected List<Parameter> createParameters(Column targetColumn) {
		List<Parameter> parameters = Lists.newArrayList();
		try {
			NamesMetadata labels = targetColumn.getMetadata(NamesMetadata.class);
			if (labels.getTexts().isEmpty())
				addLabelParameter(parameters);
		} catch (NoSuchMetadataException e) {
			addLabelParameter(parameters);
		}
		return parameters;
	}

	private void addLabelParameter(List<Parameter> parameters) {
		parameters.add(new LocalizedTextParameter(LABEL_ID, "Column lable", "The column label", Cardinality.ONE));
	}

	@Override
	protected List<Class<? extends ColumnType>> getAllowedSourceColumnTypes() {
		return allowedSourceColumnTypes;
	}

	@Override
	public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
		checkInvocation(invocation);
		return new ChangeToAttributeColumn(invocation, cubeManager, connectionProvider);
	}

}
