/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.column;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.column.RemoveColumn;
import org.gcube.data.analysis.tabulardata.operation.factories.types.ColumnTransformationWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.EligibleOperation;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationNotEligibleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RemoveColumnFactory
extends ColumnTransformationWorkerFactory {
    private static final Logger log = LoggerFactory.getLogger(RemoveColumnFactory.class);
    private static final OperationDescriptor.OperationId OPERATION_ID = new OperationDescriptor.OperationId(RemoveColumnFactory.class);
    @Inject
    private CubeManager cubeManager;

    public EligibleOperation getEligibleOperation(TableId tableId, ColumnLocalId columnId) throws OperationNotEligibleException {
        return this.getEligibleOperation(this.cubeManager.getTable(tableId), columnId);
    }

    private EligibleOperation getEligibleOperation(Table table, ColumnLocalId columnId) throws OperationNotEligibleException {
        try {
            this.checkTable(table, columnId);
            ArrayList parameters = Lists.newArrayList();
            return new EligibleOperation(this.getOperationDescriptor(), (List)parameters, table.getId(), columnId);
        }
        catch (Exception e) {
            log.warn("Operation not eligible", (Throwable)e);
            throw new OperationNotEligibleException("Operation is not eligible");
        }
    }

    private void checkTable(Table table, ColumnLocalId columnId) {
        table.getColumnById(columnId);
    }

    public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.checkInvocation(invocation);
        return new RemoveColumn(this.cubeManager, invocation);
    }

    private void checkInvocation(OperationInvocation invocation) throws InvalidInvocationException {
        try {
            this.checkTable(this.cubeManager.getTable(invocation.getTargetTableId()), invocation.getTargetColumnId());
        }
        catch (Exception e) {
            throw new InvalidInvocationException(invocation, e);
        }
    }

    protected String getOperationName() {
        return "Remove column";
    }

    protected String getOperationDescription() {
        return "Remove column from table";
    }

    protected OperationDescriptor.OperationId getOperationId() {
        return OPERATION_ID;
    }
}

