/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.column.typechange;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataLocaleMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.operation.column.typechange.ChangeColumnTypeTransformation;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;

public class DefaultColumnTypeTransformation
extends ChangeColumnTypeTransformation {
    private ColumnType managedColumnType;

    public DefaultColumnTypeTransformation(OperationInvocation invocation, CubeManager cubeManager, DatabaseConnectionProvider databaseConnectionProvider, ColumnType managedColumnType) {
        super(invocation, cubeManager, databaseConnectionProvider);
        this.managedColumnType = managedColumnType;
    }

    @Override
    protected Collection<ColumnMetadata> getMetadataToSet() {
        return this.collectMetadataToSet(this.invocation);
    }

    private Collection<ColumnMetadata> collectMetadataToSet(OperationInvocation invocation) {
        Locale dataLocale;
        ArrayList result = Lists.newArrayList();
        LocalizedText newLabel = this.retrieveLabelParameter(invocation);
        if (newLabel != null) {
            NamesMetadata oldNamesMeta;
            NamesMetadata newNamesMeta = new NamesMetadata();
            try {
                oldNamesMeta = (NamesMetadata)this.targetColumn.getMetadata(NamesMetadata.class);
            }
            catch (NoSuchMetadataException e) {
                oldNamesMeta = new NamesMetadata();
            }
            newNamesMeta.setTexts(oldNamesMeta.getTexts());
            newNamesMeta.addText(newLabel);
            result.add(newNamesMeta);
        }
        if ((dataLocale = this.retrieveDataLocaleParameter(invocation)) != null) {
            result.add(new DataLocaleMetadata(dataLocale));
        }
        return result;
    }

    private LocalizedText retrieveLabelParameter(OperationInvocation invocation) {
        return (LocalizedText)invocation.getParameterInstances().get("label");
    }

    private Locale retrieveDataLocaleParameter(OperationInvocation invocation) {
        return (Locale)invocation.getParameterInstances().get("dataLocale");
    }

    @Override
    protected ColumnType getManagedColumnType() {
        return this.managedColumnType;
    }
}

