/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.table;

import com.google.common.collect.Lists;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.model.table.type.DatasetTableType;
import org.gcube.data.analysis.tabulardata.operation.factories.types.TableTransformationWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.table.CreateDatasetView;
import org.gcube.data.analysis.tabulardata.operation.worker.EligibleOperation;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationNotEligibleException;

@Singleton
public class CreateDatasetViewFactory
extends TableTransformationWorkerFactory {
    private static final OperationDescriptor.OperationId OPERATION_ID = new OperationDescriptor.OperationId(CreateDatasetViewFactory.class);
    private static final List<Parameter> parameters = Lists.newArrayList();
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;

    @Inject
    public CreateDatasetViewFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
    }

    public EligibleOperation getEligibleOperation(TableId tableId) throws OperationNotEligibleException {
        return this.getEligibleOperation(this.cubeManager.getTable(tableId));
    }

    public EligibleOperation getEligibleOperation(Table table) throws OperationNotEligibleException {
        try {
            this.checkEligibility(table);
        }
        catch (Exception e) {
            throw new OperationNotEligibleException(table.getId(), e.getMessage());
        }
        return new EligibleOperation(this.getOperationDescriptor(), parameters, table.getId());
    }

    private void checkEligibility(Table table) throws Exception {
        if (!table.getTableType().equals((Object)new DatasetTableType())) {
            throw new Exception("Table is not a dataset");
        }
        if (!table.hasRelationships()) {
            throw new Exception("Table has no relationship, a view is not needed");
        }
    }

    public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.checkInvocation(invocation);
        return new CreateDatasetView(this.cubeManager, this.connectionProvider, invocation);
    }

    private void checkInvocation(OperationInvocation invocation) throws InvalidInvocationException {
        Table table = this.cubeManager.getTable(invocation.getTargetTableId());
        try {
            this.checkEligibility(table);
        }
        catch (Exception e) {
            throw new InvalidInvocationException(invocation, "Target table is not eligible");
        }
    }

    protected String getOperationName() {
        return "Create dataset view";
    }

    protected String getOperationDescription() {
        return "Create a dataset materialized view with data from linked codelists";
    }

    protected OperationDescriptor.OperationId getOperationId() {
        return OPERATION_ID;
    }
}

