package org.gcube.data.analysis.tabulardata.operation.column;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.worker.BaseWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationException;

import com.google.common.collect.Lists;

public class RemoveColumn extends BaseWorker {
	
	CubeManager cubeManager;
	
	Table targetTable;
	
	Column targetColumn;

	public RemoveColumn(CubeManager cubeManager, OperationInvocation invocation) {
		super(invocation);
		this.cubeManager = cubeManager;
		this.targetTable = cubeManager.getTable(invocation.getTargetTableId());
		this.targetColumn = targetTable.getColumnById(invocation.getTargetColumnId());
	}

	@Override
	public void run() {
		try {
			inProgress(0.1f);
			Table resultTable = cubeManager.createTable(targetTable.getTableType())
					.like(targetTable, true, Lists.newArrayList(targetColumn)).create();
			succeed(resultTable);
		} catch (Exception e) {
			fail(new OperationException("Unable to create table with removed column",e));
		}
	}

}
