package org.gcube.data.analysis.tabulardata.operation.column;

import java.util.List;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.exceptions.NoSuchColumnException;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.worker.BaseWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationException;

public class ChangeLabel extends BaseWorker {
	
	private CubeManager cubeManager;
	
	private LocalizedText labelToChange;
	
	private LocalizedText newLabel;
	
	private TableId targetTableId;
	
	private ColumnLocalId targetColumnId;
	
	public ChangeLabel(OperationInvocation invocation, CubeManager cubeManager, TableId targetTableId,
			ColumnLocalId targetColumnId, LocalizedText labelToChange, LocalizedText newLabel) {
		super(invocation);
		this.cubeManager = cubeManager;
		this.labelToChange = labelToChange;
		this.newLabel = newLabel;
		this.targetTableId = targetTableId;
		this.targetColumnId = targetColumnId;
	}

	@Override
	public void run() {
		inProgress(0.1f);
		Table targetTable = getTable();
		inProgress(0.2f);
		try {
			NamesMetadata namesMeta = buildNewMetadata(targetTable);
			inProgress(0.3f);
			Table resultTable = createNewTable(namesMeta);
			succeed(resultTable);
		} catch (OperationException e) {
			fail(e);
			return;
		} catch (Exception e){
			fail (new OperationException(e.getMessage()));
		}		
		
	}

	private Table createNewTable(NamesMetadata namesMeta) {
		return cubeManager.modifyTableMeta(targetTableId).setColumnMetadata(targetColumnId, namesMeta).create();
	}

	private NamesMetadata buildNewMetadata(Table targetTable) throws OperationException {
		NamesMetadata namesMeta;
		try {
			namesMeta = targetTable.getColumnById(targetColumnId).getMetadata(NamesMetadata.class);
		} catch (NoSuchColumnException e) {
			throw new OperationException("Unable to locate target column in table");
		} catch (NoSuchMetadataException e) {
			throw new OperationException("Column has no label to change");
		}
		List<LocalizedText> labels = namesMeta.getTexts();
		labels.remove(labelToChange);
		labels.add(newLabel);
		namesMeta = new NamesMetadata();
		namesMeta.setTexts(labels);
		return namesMeta;
	}

	private Table getTable() {
		return cubeManager.getTable(targetTableId);
	}

	

}
