/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.validation;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.time.PeriodType;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.factories.types.ColumnValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.MultivaluedStringParameter;
import org.gcube.data.analysis.tabulardata.operation.time.PeriodTypeHelperProvider;
import org.gcube.data.analysis.tabulardata.operation.validation.TimeDimensionColumnValidator;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

@Singleton
public class TimeDimensionColumnValidatorFactory
extends ColumnValidatorFactory {
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private PeriodTypeHelperProvider periodTypeHelperProvider;
    public static final MultivaluedStringParameter PERIOD_FORMAT_PARAMETER;
    private static final OperationId OPERATION_ID;
    private static final List<Parameter> parameters;

    @Inject
    public TimeDimensionColumnValidatorFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, PeriodTypeHelperProvider periodTypeHelperProvider) {
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.periodTypeHelperProvider = periodTypeHelperProvider;
    }

    public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation);
        this.checkColumnEligibility(invocation);
        return new TimeDimensionColumnValidator(invocation, this.cubeManager, this.connectionProvider, this.periodTypeHelperProvider);
    }

    private void checkColumnEligibility(OperationInvocation invocation) throws InvalidInvocationException {
        Table targetTable = this.cubeManager.getTable(invocation.getTargetTableId());
        Column targetColumn = targetTable.getColumnById(invocation.getTargetColumnId());
        if (!targetColumn.getDataType().getClass().equals(TextType.class)) {
            throw new InvalidInvocationException(invocation, "Target column is not a text column");
        }
    }

    protected String getOperationName() {
        return "Period format check";
    }

    protected String getOperationDescription() {
        return "Check if a column data represents a valid period format";
    }

    protected List<Parameter> getParameters() {
        return parameters;
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    static {
        OPERATION_ID = new OperationId(5005L);
        ArrayList<String> admittedValues = new ArrayList<String>();
        for (PeriodType periodType : PeriodType.values()) {
            admittedValues.add(periodType.getName());
        }
        PERIOD_FORMAT_PARAMETER = new MultivaluedStringParameter("periodFormat", "Period Format", "Period representation format", Cardinality.ONE, admittedValues);
        parameters = new ArrayList<Parameter>();
        parameters.add((Parameter)PERIOD_FORMAT_PARAMETER);
    }
}

