package org.gcube.data.analysis.tabulardata.operation.column;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.inject.Inject;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.DimensionColumnType;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateDimensionColumnFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

public class ChangeToDimensionColumnFactory extends ChangeColumnTypeTransformationFactory {

	private static final ColumnType MANAGED_COLUMN_TYPE = new DimensionColumnType();

	private static final OperationId OPERATION_ID = new OperationId(2006);
	
	private final static List<Parameter> parameters = new ArrayList<Parameter>();

	private CubeManager cubeManager;

	private DatabaseConnectionProvider connectionProvider;

	private ValidateDimensionColumnFactory validationFactory;

	static {
//		List<TableType> allowedTableTypes = new ArrayList<TableType>();
//		allowedTableTypes.add(new CodelistTableType());
//		List<ColumnType> allowedColumnTypes = new ArrayList<ColumnType>();
//		allowedColumnTypes.add(new CodeColumnType());
//		allowedColumnTypes.add(new CodeNameColumnType());
//		TARGET_COLUMN_PARAMETER = new TargetColumnParameter("refColumn", "Codelist referenced column",
//				"A codelist column containing values that are contained", Cardinality.ONE, allowedTableTypes,
//				allowedColumnTypes);
//		parameters.add(TARGET_COLUMN_PARAMETER);
		
		//Needed by validation
		parameters.add(ValidateDimensionColumnFactory.TARGET_COLUMN_PARAMETER);
		parameters.add(ValidateDimensionColumnFactory.EXTERNAL_CONDITION_PARAMETER);
				
	}

	@Inject
	public ChangeToDimensionColumnFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider,
			ValidateDimensionColumnFactory validationFactory) {
		this.cubeManager = cubeManager;
		this.connectionProvider = connectionProvider;
		this.validationFactory= validationFactory;
	}

	@Override
	public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
		performBaseChecks(invocation);
		return new ChangeToDimensionColumn(invocation, cubeManager, connectionProvider);
	}

	@Override
	protected ColumnType getManagedColumnType() {
		return MANAGED_COLUMN_TYPE;
	}

	@Override
	protected List<Parameter> getParameters() {
		return parameters;
	}

	
	@Override
	protected OperationId getOperationId() {
		return OPERATION_ID;
	}
	
	@Override
	public List<WorkerFactory> getPrecoditionValidations() {
		return Arrays.asList(new WorkerFactory[]{
				validationFactory
		});
	}
	
}
