/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.column;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AnnotationColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeDescriptionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeNameColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.MeasureColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.column.ChangeColumnTypeTransformationFactory;
import org.gcube.data.analysis.tabulardata.operation.column.SimpleTextTypedColumnTypeTransformation;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.validation.ColumnTypeCastValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

@Singleton
public abstract class SimpleTextTypedColumnTypeTransformationFactory
extends ChangeColumnTypeTransformationFactory {
    public static final List<Class<? extends ColumnType>> allowedSourceColumnTypes = Lists.newArrayList();
    private DatabaseConnectionProvider connectionProvider;
    private CubeManager cubeManager;

    public SimpleTextTypedColumnTypeTransformationFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
    }

    public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation);
        invocation.getParameterInstances().put(ColumnTypeCastValidatorFactory.TARGET_TYPE_PARAMETER.getIdentifier(), new TextType());
        return new SimpleTextTypedColumnTypeTransformation(invocation, this.cubeManager, this.connectionProvider, this.getManagedColumnType());
    }

    protected List<Class<? extends ColumnType>> getAllowedSourceColumnTypes() {
        return allowedSourceColumnTypes;
    }

    protected List<Parameter> getParameters() {
        return new ArrayList<Parameter>();
    }

    private void checkTargetColumnEligibility(OperationInvocation invocation) throws InvalidInvocationException {
        Table targetTable = this.cubeManager.getTable(invocation.getTargetTableId());
        Column targetColumn = targetTable.getColumnById(invocation.getTargetColumnId());
        if (!this.getAllowedSourceColumnTypes().contains(targetColumn.getColumnType().getClass())) {
            throw new InvalidInvocationException(invocation, "Source column is not of a valid type: " + targetColumn.getColumnType());
        }
        if (targetColumn.getColumnType().equals((Object)this.getManagedColumnType())) {
            throw new InvalidInvocationException(invocation, "Source column is already of type " + this.getManagedColumnType().getName());
        }
    }

    static {
        allowedSourceColumnTypes.add(AnnotationColumnType.class);
        allowedSourceColumnTypes.add(MeasureColumnType.class);
        allowedSourceColumnTypes.add(AttributeColumnType.class);
        allowedSourceColumnTypes.add(CodeColumnType.class);
        allowedSourceColumnTypes.add(CodeNameColumnType.class);
        allowedSourceColumnTypes.add(CodeDescriptionColumnType.class);
    }
}

