/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.column;

import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.List;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.factories.DimensionColumnFactory;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.relationship.ColumnRelationship;
import org.gcube.data.analysis.tabulardata.model.relationship.ImmutableColumnRelationship;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateDimensionColumnFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;

public class ChangeToDimensionColumn
extends Worker {
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private Table targetTable;
    private Column targetColumn;
    private Table refTable;
    private Column refColumn;
    private Table newTable;
    private Column dimensionColumn;

    public ChangeToDimensionColumn(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
    }

    protected WorkerResult execute() throws WorkerException {
        this.retrieveParameters();
        this.updateProgress(0.1f);
        this.createNewTable();
        this.updateProgress(0.3f);
        this.fillNewTableWithData();
        return new ImmutableWorkerResult(this.newTable);
    }

    private void retrieveParameters() {
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        this.targetColumn = this.targetTable.getColumnById(this.getSourceInvocation().getTargetColumnId());
        ColumnReference columnReferenceParam = (ColumnReference)OperationHelper.getParameter(ValidateDimensionColumnFactory.TARGET_COLUMN_PARAMETER, this.getSourceInvocation());
        this.refTable = this.cubeManager.getTable(columnReferenceParam.getTableId());
        this.refColumn = this.refTable.getColumnById(columnReferenceParam.getColumnId());
    }

    private void createNewTable() {
        ImmutableColumnRelationship relationship = new ImmutableColumnRelationship(this.refTable);
        this.dimensionColumn = DimensionColumnFactory.create((ColumnRelationship)relationship);
        if (this.targetColumn.contains(NamesMetadata.class)) {
            this.dimensionColumn.setMetadata(this.targetColumn.getMetadata(NamesMetadata.class));
        }
        this.newTable = this.cubeManager.createTable(this.targetTable.getTableType()).like(this.targetTable, true, (List)Lists.newArrayList((Object[])new Column[]{this.targetColumn})).addColumnAfter(this.dimensionColumn, this.targetColumn).create();
    }

    private void fillNewTableWithData() throws WorkerException {
        String sqlCommand = this.getFillDimensionColumnSQLCommand();
        try {
            SQLHelper.executeSQLCommand(sqlCommand, this.connectionProvider);
        }
        catch (SQLException e) {
            throw new WorkerException("Unable to create a reference for some data", (Throwable)e);
        }
    }

    private String getFillDimensionColumnSQLCommand() {
        return String.format("UPDATE %1$s AS new_table SET %2$s = refCol.id FROM (SELECT id, %5$s as val FROM %4$s) as refCol, %6$s as targetTable WHERE targetTable.id = new_table.id and refCol.val=targetTable.%3$s;", this.newTable.getName(), this.dimensionColumn.getName(), this.targetColumn.getName(), this.refTable.getName(), this.refColumn.getName(), this.targetTable.getName());
    }
}

