/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.validation;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.factories.types.ColumnValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.DataTypeParameter;
import org.gcube.data.analysis.tabulardata.operation.validation.ColumnTypeCastValidator;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

public class ColumnTypeCastValidatorFactory
extends ColumnValidatorFactory {
    private static final List<Parameter> parameters = new ArrayList<Parameter>();
    private static final OperationId OPERATION_ID = new OperationId(5002L);
    public static final DataTypeParameter TARGET_TYPE_PARAMETER = new DataTypeParameter("targetDataType", "Target type", "The data type on which the cast should be checked", Cardinality.ONE);
    CubeManager cubeManager;
    DatabaseConnectionProvider connectionProvider;

    static {
        parameters.add((Parameter)TARGET_TYPE_PARAMETER);
    }

    @Inject
    public ColumnTypeCastValidatorFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
    }

    public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        return new ColumnTypeCastValidator(invocation, this.cubeManager, this.connectionProvider);
    }

    protected String getOperationName() {
        return "Column type cast check";
    }

    protected String getOperationDescription() {
        return "Check if a column type can be casted to another one";
    }

    protected List<Parameter> getParameters() {
        return parameters;
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }
}

