/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableMetaCreator;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.logical.IsNotNull;
import org.gcube.data.analysis.tabulardata.expression.logical.Or;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.type.AnnotationColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeDescriptionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeNameColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataLocaleMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.Validation;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ValidationsMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.validation.DuplicateRowValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.validation.DuplicateValuesInColumnValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateDataWithExpressionFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerWrapper;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodelistValidator
extends Worker {
    private static final Logger log = LoggerFactory.getLogger(CodelistValidator.class);
    private static final Class[] validColumnTypes = new Class[]{CodeColumnType.class, CodeNameColumnType.class, CodeDescriptionColumnType.class, AnnotationColumnType.class, IdColumnType.class};
    private DuplicateValuesInColumnValidatorFactory duplicateInColumnFactory;
    private ValidateDataWithExpressionFactory validateDataWithExpressionFactory;
    private DuplicateRowValidatorFactory duplicateRowsFactory;
    CubeManager cubeManager;
    DatabaseConnectionProvider connectionProvider;
    Table targetTable;
    List<Validation> toSetValidations;
    HashMap<ColumnLocalId, List<Validation>> columnValidations = new HashMap();

    public CodelistValidator(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, DuplicateValuesInColumnValidatorFactory duplicateInColumnFactory, ValidateDataWithExpressionFactory validateWithExpressionFactory, DuplicateRowValidatorFactory duplicateRowFactory) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.duplicateInColumnFactory = duplicateInColumnFactory;
        this.validateDataWithExpressionFactory = validateWithExpressionFactory;
        this.duplicateRowsFactory = duplicateRowFactory;
    }

    protected WorkerResult execute() throws WorkerException {
        this.retrieveTargetTable();
        this.updateProgress(0.1f);
        log.debug("Checking metadata constraints for table " + this.targetTable.getId());
        this.initializeValidationsMetadata();
        log.debug("Unique code column : " + this.checkExistingUniqueCodeColumn());
        log.debug("Existing code name column : " + this.checkExistingCodeNameColumn());
        log.debug("Duplicate locales : " + this.checkDuplicateCodeNameDataLocales());
        log.debug("Allowed column types only : " + this.checkInvalidColumnTypes());
        log.debug("Needed locale and labels : " + this.checkLocaleAndLabels());
        this.updateProgress(0.3f);
        this.updateProgress(0.4f);
        log.debug("Validating duplicates in code columns..");
        this.checkDuplicatesInCodeColumn();
        this.updateProgress(0.5f);
        log.debug("Validating not null in code columns ...");
        this.checkNullValuesInCodeColumn();
        this.updateProgress(0.7f);
        log.debug("Validating name presence in each tuple...");
        this.checkNamePresenceInEachTuple();
        this.updateProgress(0.8f);
        log.debug("Validating tuple uniqueness... ");
        this.checkDuplicates();
        this.updateProgress(0.9f);
        return new ImmutableWorkerResult(this.createMetaValidatedTable());
    }

    private void retrieveTargetTable() {
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
    }

    private void initializeValidationsMetadata() {
        this.toSetValidations = CodelistValidator.getToEnrichTableMetaValidations(this.targetTable);
    }

    private boolean checkExistingUniqueCodeColumn() {
        boolean valid;
        List codeColumns = this.targetTable.getColumnsByType(new Class[]{CodeColumnType.class});
        int codeColumnCount = codeColumns.size();
        boolean bl = valid = codeColumnCount == 1;
        if (!valid) {
            for (Column col : codeColumns) {
                this.addColumnValidation("Duplicated Code column", valid, col);
            }
        }
        this.toSetValidations.add(new Validation("Must have one and only code column", valid));
        return valid;
    }

    private boolean checkExistingCodeNameColumn() {
        List codeNameColumns = this.targetTable.getColumnsByType(new Class[]{CodeNameColumnType.class});
        boolean valid = codeNameColumns.size() > 0;
        this.toSetValidations.add(new Validation("Must have at least one codename columns", valid));
        return valid;
    }

    private boolean checkDuplicateCodeNameDataLocales() {
        List codeNameColumns = this.targetTable.getColumnsByType(new Class[]{CodeNameColumnType.class});
        HashMap codeNamesLocales = new HashMap();
        for (Column c : codeNameColumns) {
            if (!c.contains(DataLocaleMetadata.class)) continue;
            String locale = ((DataLocaleMetadata)c.getMetadata(DataLocaleMetadata.class)).getLocale();
            if (!codeNamesLocales.containsKey(locale)) {
                codeNamesLocales.put(locale, new ArrayList());
            }
            ((List)codeNamesLocales.get(locale)).add(c);
        }
        boolean valid = true;
        for (Map.Entry entry : codeNamesLocales.entrySet()) {
            boolean duplicate;
            boolean bl = duplicate = ((List)entry.getValue()).size() > 1;
            if (duplicate) {
                valid = false;
            }
            for (Column col : (List)entry.getValue()) {
                this.addColumnValidation("Code column with unique locale", !duplicate, col);
            }
        }
        this.toSetValidations.add(new Validation("Must have at most one CodeName column for each data locale", valid));
        return valid;
    }

    private boolean checkInvalidColumnTypes() {
        boolean globalValid = true;
        for (Column col : this.targetTable.getColumnsByType(validColumnTypes)) {
            this.addColumnValidation("Allowed column type ", true, col);
        }
        List invalidCols = this.targetTable.getColumnsExceptTypes(validColumnTypes);
        globalValid = invalidCols.isEmpty();
        if (!globalValid) {
            for (Column col : invalidCols) {
                this.addColumnValidation("Allowed column type ", false, col);
            }
        }
        this.toSetValidations.add(new Validation("Only Code, CodeName, CodeDescription and Annotation column types allowed.", globalValid));
        return globalValid;
    }

    private boolean checkLocaleAndLabels() {
        boolean globalValid = true;
        Class[] toCheckColumnTypes = new Class[]{CodeNameColumnType.class, CodeDescriptionColumnType.class, AnnotationColumnType.class};
        for (Column col : this.targetTable.getColumnsByType(toCheckColumnTypes)) {
            boolean validColumn = CodelistValidator.checkLocaleAndLabels(col);
            if (!validColumn) {
                globalValid = false;
            }
            this.addColumnValidation("Must have Data locale metadata and at least one label", validColumn, col);
        }
        this.toSetValidations.add(new Validation("Each CodeName, CodeDescription and Annotation column with DataLocale and at least one label", globalValid));
        return globalValid;
    }

    private void checkDuplicatesInCodeColumn() throws WorkerException {
        List toCheckColumns = this.targetTable.getColumnsByType(new Class[]{CodeColumnType.class});
        WorkerWrapper wrapper = new WorkerWrapper((WorkerFactory)this.duplicateInColumnFactory);
        for (Column col : toCheckColumns) {
            try {
                WorkerStatus status = wrapper.execute(this.targetTable.getId(), col.getLocalId(), null);
                this.processStep(status, wrapper.getResult());
            }
            catch (InvalidInvocationException e) {
                throw new WorkerException("Unable to execute wrapped worker ", (Throwable)e);
            }
        }
    }

    private void checkNullValuesInCodeColumn() throws WorkerException {
        List toCheckColumns = this.targetTable.getColumnsByType(new Class[]{CodeColumnType.class});
        WorkerWrapper wrapper = new WorkerWrapper((WorkerFactory)this.validateDataWithExpressionFactory);
        for (Column col : toCheckColumns) {
            try {
                ColumnReference targetColumnReference = new ColumnReference(this.targetTable.getId(), col.getLocalId());
                IsNotNull condition = new IsNotNull((Expression)targetColumnReference);
                HashMap<String, IsNotNull> map = new HashMap<String, IsNotNull>();
                map.put(ValidateDataWithExpressionFactory.EXPRESSION_PARAMETER.getIdentifier(), condition);
                WorkerStatus status = wrapper.execute(this.targetTable.getId(), col.getLocalId(), map);
                this.processStep(status, wrapper.getResult());
            }
            catch (InvalidInvocationException e) {
                throw new WorkerException("Unable to execute wrapped worker ", (Throwable)e);
            }
        }
    }

    private void checkNamePresenceInEachTuple() throws WorkerException {
        List toCheckColumns = this.targetTable.getColumnsByType(new Class[]{CodeNameColumnType.class});
        ArrayList<IsNotNull> orArguments = new ArrayList<IsNotNull>();
        for (Column col : toCheckColumns) {
            ColumnReference targetColumnReference = new ColumnReference(this.targetTable.getId(), col.getLocalId());
            IsNotNull condition = new IsNotNull((Expression)targetColumnReference);
            orArguments.add(condition);
        }
        Object toApplyCondition = null;
        if (orArguments.size() == 0) {
            log.debug("The table hasn't codenames columns");
        } else {
            toApplyCondition = orArguments.size() == 1 ? (Expression)orArguments.get(0) : new Or(orArguments);
            try {
                WorkerWrapper wrapper = new WorkerWrapper((WorkerFactory)this.validateDataWithExpressionFactory);
                HashMap<String, Expression> map = new HashMap<String, Expression>();
                map.put(ValidateDataWithExpressionFactory.EXPRESSION_PARAMETER.getIdentifier(), (Expression)toApplyCondition);
                WorkerStatus status = wrapper.execute(this.targetTable.getId(), null, map);
                this.processStep(status, wrapper.getResult());
            }
            catch (InvalidInvocationException e) {
                throw new WorkerException("Unable to execute wrapped worker ", (Throwable)e);
            }
        }
    }

    private void checkDuplicates() throws WorkerException {
        try {
            WorkerWrapper wrapper = new WorkerWrapper((WorkerFactory)this.duplicateRowsFactory);
            WorkerStatus status = wrapper.execute(this.targetTable.getId(), null, null);
            this.processStep(status, wrapper.getResult());
        }
        catch (InvalidInvocationException e) {
            throw new WorkerException("Unable to execute wrapped worker ", (Throwable)e);
        }
    }

    private void checkDuplicatesInAnyNames() throws WorkerException {
    }

    private void addColumnValidation(String msg, boolean valid, Column col) {
        ColumnLocalId id = col.getLocalId();
        if (!this.columnValidations.containsKey(id)) {
            this.columnValidations.put(id, CodelistValidator.getToEnrichColumnMetaValidations(this.targetTable.getColumnById(id)));
        }
        this.columnValidations.get(id).add(new Validation(msg, valid));
    }

    private Table createMetaValidatedTable() {
        TableMetaCreator tmc = this.cubeManager.modifyTableMeta(this.targetTable.getId());
        tmc.setTableMetadata(new TableMetadata[]{new ValidationsMetadata(this.toSetValidations)});
        for (Map.Entry<ColumnLocalId, List<Validation>> entry : this.columnValidations.entrySet()) {
            ValidationsMetadata columnValidMeta = new ValidationsMetadata(entry.getValue());
            tmc.setColumnMetadata(entry.getKey(), new ColumnMetadata[]{columnValidMeta});
        }
        return tmc.create();
    }

    private void processStep(WorkerStatus status, WorkerResult result) throws WorkerException {
        if (!status.equals((Object)WorkerStatus.SUCCEDED)) {
            throw new WorkerException("Wrapped step has failed, see previous log");
        }
        log.debug("Sub Worker Succeded. Switching working table from " + this.targetTable + " to " + result.getResultTable());
        this.targetTable = result.getResultTable();
    }

    private static List<Validation> getToEnrichTableMetaValidations(Table table) {
        ArrayList<Validation> foundValidations = new ArrayList<Validation>();
        try {
            ValidationsMetadata validationsMetadata = (ValidationsMetadata)table.getMetadata(ValidationsMetadata.class);
            foundValidations.addAll(validationsMetadata.getValidations());
        }
        catch (NoSuchMetadataException e) {
            log.debug("No validation metadata found, returned empty List");
        }
        return foundValidations;
    }

    private static List<Validation> getToEnrichColumnMetaValidations(Column column) {
        ArrayList<Validation> foundValidations = new ArrayList<Validation>();
        try {
            ValidationsMetadata validationsMetadata = (ValidationsMetadata)column.getMetadata(ValidationsMetadata.class);
            foundValidations.addAll(validationsMetadata.getValidations());
        }
        catch (NoSuchMetadataException e) {
            log.debug("No validation metadata found, returned empty List");
        }
        return foundValidations;
    }

    private static boolean checkLocaleAndLabels(Column col) {
        try {
            col.getMetadata(DataLocaleMetadata.class);
            return !((NamesMetadata)col.getMetadata(NamesMetadata.class)).getTexts().isEmpty();
        }
        catch (Exception e) {
            return false;
        }
    }
}

