/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.validation;

import java.util.Collections;
import java.util.List;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.metadata.common.Validation;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ValidationsMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;

public class ValidateDataset
extends Worker {
    private CubeManager cube;

    public ValidateDataset(OperationInvocation sourceInvocation, CubeManager cube) {
        super(sourceInvocation);
        this.cube = cube;
    }

    protected WorkerResult execute() throws WorkerException {
        Table targetTable = this.cube.getTable(this.getSourceInvocation().getTargetTableId());
        Validation toSet = new Validation("The table is a valid dataset", true);
        ValidationsMetadata meta = null;
        try {
            meta = (ValidationsMetadata)targetTable.getMetadata(ValidationsMetadata.class);
            List previousValidations = meta.getValidations();
            previousValidations.add(toSet);
            meta = new ValidationsMetadata(previousValidations);
        }
        catch (NoSuchMetadataException e) {
            meta = new ValidationsMetadata(Collections.singletonList(toSet));
        }
        return new ImmutableWorkerResult(this.cube.modifyTableMeta(this.getSourceInvocation().getTargetTableId()).setTableMetadata(new TableMetadata[]{meta}).create());
    }
}

