/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation;

import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.metadata.Locales;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;

public class OperationHelper {
    public static <T> T getParameter(LeafParameter<T> parameter, OperationInvocation invocation) {
        Object instance = invocation.getParameterInstances().get(parameter.getIdentifier());
        if (instance == null) {
            throw new RuntimeException(String.format("Parameter with id '%s' not found in invocation", parameter.getIdentifier()));
        }
        try {
            return (T)instance;
        }
        catch (ClassCastException e) {
            throw new RuntimeException(String.format("Provided parameter with id '%s' is not of valid type", parameter.getIdentifier()));
        }
    }

    public static final String retrieveColumnLabel(Column targetColumn) {
        if (targetColumn.contains(NamesMetadata.class)) {
            NamesMetadata namesMeta = (NamesMetadata)targetColumn.getMetadata(NamesMetadata.class);
            if (namesMeta.hasTextWithLocale(Locales.getDefaultLocale())) {
                return namesMeta.getTextWithLocale(Locales.getDefaultLocale()).getValue();
            }
            if (namesMeta.getTexts().size() > 0) {
                return ((LocalizedText)namesMeta.getTexts().get(0)).getValue();
            }
        }
        return "Unlabelled column";
    }
}

