/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.validation;

import java.sql.SQLException;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableMetaCreator;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.MalformedExpressionException;
import org.gcube.data.analysis.tabulardata.expression.TableReferenceReplacer;
import org.gcube.data.analysis.tabulardata.expression.evaluator.EvaluatorException;
import org.gcube.data.analysis.tabulardata.expression.evaluator.description.DescriptionExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.factories.ValidationColumnFactory;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataValidationMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ValidationReferencesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.ValidationHelper;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateDataWithExpressionFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateDataWithExpression
extends Worker {
    private static final Logger log = LoggerFactory.getLogger(ValidateDataWithExpression.class);
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private Table targetTable;
    private Expression validationExpression;
    private String expressionDescription = null;
    private Column validationColumn;
    private SQLExpressionEvaluatorFactory sqlEvaluatorFactory;
    private DescriptionExpressionEvaluatorFactory descriptionEvaluatorFactory;
    private Table resultTable;

    public ValidateDataWithExpression(OperationInvocation invocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory sqlEvaluatorFactory, DescriptionExpressionEvaluatorFactory descriptionEvaluatorFactory) {
        super(invocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.targetTable = cubeManager.getTable(invocation.getTargetTableId());
        this.validationExpression = (Expression)invocation.getParameterInstances().get(ValidateDataWithExpressionFactory.EXPRESSION_PARAMETER.getIdentifier());
        if (invocation.getParameterInstances().containsKey(ValidateDataWithExpressionFactory.DESCRIPTION_PARAMETER)) {
            this.expressionDescription = (String)invocation.getParameterInstances().get(ValidateDataWithExpressionFactory.DESCRIPTION_PARAMETER.getIdentifier());
        }
        this.sqlEvaluatorFactory = sqlEvaluatorFactory;
        this.descriptionEvaluatorFactory = descriptionEvaluatorFactory;
    }

    protected WorkerResult execute() throws WorkerException {
        this.updateProgress(0.1f);
        this.addValidationColumn();
        this.updateProgress(0.4f);
        this.fillValidationColumn();
        this.updateProgress(0.7f);
        this.evaluateValidityAndUpdateTableMeta();
        return new ImmutableWorkerResult(this.resultTable);
    }

    private void evaluateValidityAndUpdateTableMeta() throws WorkerException {
        boolean validationResult = ValidationHelper.evaluateValidationColumnValidity(this.connectionProvider, this.targetTable.getName(), this.validationColumn.getName());
        TableMetaCreator tmc = this.cubeManager.modifyTableMeta(this.targetTable.getId());
        DataValidationMetadata validationMeta = new DataValidationMetadata((LocalizedText)new ImmutableLocalizedText(this.createValidationDescription()), validationResult);
        tmc.setColumnMetadata(this.validationColumn.getLocalId(), new ColumnMetadata[]{validationMeta});
        this.resultTable = tmc.create();
    }

    private String createValidationDescription() {
        return (String)this.descriptionEvaluatorFactory.getEvaluator(this.validationExpression).evaluate();
    }

    private void fillValidationColumn() throws WorkerException {
        try {
            SQLHelper.executeSQLBatchCommands(this.connectionProvider, this.generateSetAllFalseSqlCommand(), this.generateValidationSqlCommand());
        }
        catch (SQLException e) {
            e.getNextException().printStackTrace();
            throw new WorkerException("Error occurred while executing SQL command", (Throwable)e);
        }
    }

    private String generateSetAllFalseSqlCommand() {
        return String.format("UPDATE %s SET %s = false;", this.targetTable.getName(), this.validationColumn.getName());
    }

    private String generateValidationSqlCommand() throws WorkerException {
        try {
            this.validationExpression.validate();
            return String.format("UPDATE %s SET %s = true WHERE %s;", this.targetTable.getName(), this.validationColumn.getName(), this.sqlEvaluatorFactory.getEvaluator(this.validationExpression).evaluate());
        }
        catch (EvaluatorException e) {
            throw new WorkerException("Unable to evaluate epression", (Throwable)e);
        }
        catch (MalformedExpressionException e) {
            throw new WorkerException("Unable to evaluate epression", (Throwable)e);
        }
    }

    private void addValidationColumn() throws WorkerException {
        String validationDescription = "Expression based validation";
        if (this.expressionDescription != null) {
            validationDescription = this.expressionDescription;
        }
        DataValidationMetadata validationMeta = new DataValidationMetadata((LocalizedText)new ImmutableLocalizedText(validationDescription), false);
        this.validationColumn = new ValidationColumnFactory().create((LocalizedText)new ImmutableLocalizedText(validationDescription), validationMeta);
        this.targetTable = this.cubeManager.addValidations(this.targetTable.getId(), new Column[]{this.validationColumn});
        log.debug("Added validation column:\n" + this.targetTable);
        try {
            TableReferenceReplacer replacer = new TableReferenceReplacer(this.validationExpression);
            TableMetaCreator creator = this.cubeManager.modifyTableMeta(this.targetTable.getId());
            for (ColumnReference refColumn : replacer.getReferences(this.targetTable.getId())) {
                ValidationReferencesMetadata referencesMeta;
                Column column = this.targetTable.getColumnById(refColumn.getColumnId());
                if (column.contains(ValidationReferencesMetadata.class)) {
                    referencesMeta = (ValidationReferencesMetadata)column.getMetadata(ValidationReferencesMetadata.class);
                    referencesMeta.add(this.validationColumn.getLocalId());
                } else {
                    referencesMeta = new ValidationReferencesMetadata(this.validationColumn.getLocalId());
                }
                creator.setColumnMetadata(refColumn.getColumnId(), new ColumnMetadata[]{referencesMeta});
            }
            creator.create();
        }
        catch (MalformedExpressionException e) {
            throw new WorkerException("Unable to get expression related columns", (Throwable)e);
        }
    }
}

