/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.validation;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.evaluator.description.DescriptionExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.factories.types.TableValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.ExpressionParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.SimpleStringParameter;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateDataWithExpression;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

@Singleton
public class ValidateDataWithExpressionFactory
extends TableValidatorFactory {
    private static final OperationId OPERATION_ID = new OperationId(5006L);
    public static final ExpressionParameter EXPRESSION_PARAMETER = new ExpressionParameter("expression", "Expression", "Expression to validate", Cardinality.ONE);
    public static final SimpleStringParameter DESCRIPTION_PARAMETER = new SimpleStringParameter("description", "Description", "Description of the evaluated expression", Cardinality.OPTIONAL);
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private SQLExpressionEvaluatorFactory sqlEvaluatorFactory;
    private DescriptionExpressionEvaluatorFactory descriptionEvaluatorFactory;

    @Inject
    public ValidateDataWithExpressionFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory sqlEvaluatorFactory, DescriptionExpressionEvaluatorFactory descriptionEvaluatorFactory) {
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.sqlEvaluatorFactory = sqlEvaluatorFactory;
        this.descriptionEvaluatorFactory = descriptionEvaluatorFactory;
    }

    public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        return new ValidateDataWithExpression(invocation, this.cubeManager, this.connectionProvider, this.sqlEvaluatorFactory, this.descriptionEvaluatorFactory);
    }

    protected String getOperationName() {
        return "Expression validation";
    }

    protected String getOperationDescription() {
        return "Validate table data against an expression";
    }

    protected List<Parameter> getParameters() {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add((Parameter)EXPRESSION_PARAMETER);
        parameters.add((Parameter)DESCRIPTION_PARAMETER);
        return parameters;
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }
}

