package org.gcube.data.analysis.tabulardata.operation.column;

import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.operation.factories.types.ColumnTransformationWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.ColumnMetadataParameter;

public abstract class ChangeColumnTypeTransformationFactory extends ColumnTransformationWorkerFactory {
	
	public static ColumnMetadataParameter ADDITIONAL_META_PARAMETER=new ColumnMetadataParameter("additionalMeta", "Additional Metadata", "Metadata to add to the column.", new Cardinality(0, Integer.MAX_VALUE));
	
	@Override
	protected String getOperationName() {
		return String.format("Change to %s column", getManagedColumnType().getName());
	}

	@Override
	protected String getOperationDescription() {
		return String.format("Change the column type to %1$s or modify a %1$s column", getManagedColumnType().getName());
	}

	protected abstract ColumnType getManagedColumnType();
	
}
