package org.gcube.data.analysis.tabulardata.operation.column;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.inject.Inject;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AnnotationColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeDescriptionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeNameColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.DimensionColumnType;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateDimensionColumnFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

import com.google.common.collect.Lists;

public class ChangeToDimensionColumnFactory extends ChangeColumnTypeTransformationFactory {

	private static final ColumnType MANAGED_COLUMN_TYPE = new DimensionColumnType();

	private static final OperationId OPERATION_ID = new OperationId(2006);
	
	private final static List<Parameter> parameters = new ArrayList<Parameter>();

	private CubeManager cubeManager;

	private DatabaseConnectionProvider connectionProvider;

	private ValidateDimensionColumnFactory validationFactory;

	private final static List<ColumnType> allowedSourceColumnTypes = Lists.newArrayList();
	
	static {
		allowedSourceColumnTypes.add(new CodeColumnType());
		allowedSourceColumnTypes.add(new CodeNameColumnType());
		allowedSourceColumnTypes.add(new CodeDescriptionColumnType());
		allowedSourceColumnTypes.add(new AttributeColumnType());
		allowedSourceColumnTypes.add(new AnnotationColumnType());
		
		
		//Needed by validation
		parameters.add(ValidateDimensionColumnFactory.TARGET_COLUMN_PARAMETER);
		parameters.add(ValidateDimensionColumnFactory.EXTERNAL_CONDITION_PARAMETER);
		parameters.add(ADDITIONAL_META_PARAMETER);		
	}

	@Inject
	public ChangeToDimensionColumnFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider,
			ValidateDimensionColumnFactory validationFactory) {
		this.cubeManager = cubeManager;
		this.connectionProvider = connectionProvider;
		this.validationFactory= validationFactory;
	}

	@Override
	public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
		performBaseChecks(invocation,cubeManager);
		checkAllowedColumnTypeTransition(invocation, cubeManager);
		return new ChangeToDimensionColumn(invocation, cubeManager, connectionProvider);
	}

	@Override
	protected ColumnType getManagedColumnType() {
		return MANAGED_COLUMN_TYPE;
	}

	@Override
	protected List<Parameter> getParameters() {
		return parameters;
	}

	
	@Override
	protected OperationId getOperationId() {
		return OPERATION_ID;
	}
	
	@Override
	public List<WorkerFactory> getPrecoditionValidations() {
		return Arrays.asList(new WorkerFactory[]{
				validationFactory
		});
	}
	
	@Override
	protected List<ColumnType> getAllowedSourceColumnTypes() {
		return allowedSourceColumnTypes;
	}
}
