package org.gcube.data.analysis.tabulardata.operation.validation;

import java.util.Collections;
import java.util.List;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.metadata.common.Validation;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ValidationsMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;

public class ValidateDataset extends Worker {

	private CubeManager cube;
	
	
	
	
	public ValidateDataset(OperationInvocation sourceInvocation,
			CubeManager cube) {
		super(sourceInvocation);
		this.cube = cube;
	}

	Table targetTable;


	@Override
	protected WorkerResult execute() throws WorkerException {
		Table targetTable=cube.getTable(getSourceInvocation().getTargetTableId());		
		Validation toSet=new Validation("The table is a valid generic table", true);
		ValidationsMetadata validations = new ValidationsMetadata(Collections.singletonList(toSet));
		cube.addValidations(targetTable.getId(), validations);
		return new ImmutableWorkerResult(targetTable);		
	}

}
