/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.column;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AnnotationColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeDescriptionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeNameColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.DimensionColumnType;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.column.ChangeColumnTypeTransformationFactory;
import org.gcube.data.analysis.tabulardata.operation.column.ChangeToDimensionColumn;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateDimensionColumnFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

public class ChangeToDimensionColumnFactory
extends ChangeColumnTypeTransformationFactory {
    private static final ColumnType MANAGED_COLUMN_TYPE = new DimensionColumnType();
    private static final OperationId OPERATION_ID = new OperationId(2006L);
    private static final List<Parameter> parameters = new ArrayList<Parameter>();
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private ValidateDimensionColumnFactory validationFactory;
    private static final List<ColumnType> allowedSourceColumnTypes = Lists.newArrayList();

    static {
        allowedSourceColumnTypes.add((ColumnType)new CodeColumnType());
        allowedSourceColumnTypes.add((ColumnType)new CodeNameColumnType());
        allowedSourceColumnTypes.add((ColumnType)new CodeDescriptionColumnType());
        allowedSourceColumnTypes.add((ColumnType)new AttributeColumnType());
        allowedSourceColumnTypes.add((ColumnType)new AnnotationColumnType());
        parameters.add((Parameter)ValidateDimensionColumnFactory.TARGET_COLUMN_PARAMETER);
        parameters.add((Parameter)ValidateDimensionColumnFactory.EXTERNAL_CONDITION_PARAMETER);
        parameters.add((Parameter)ADDITIONAL_META_PARAMETER);
    }

    @Inject
    public ChangeToDimensionColumnFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, ValidateDimensionColumnFactory validationFactory) {
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.validationFactory = validationFactory;
    }

    public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        this.checkAllowedColumnTypeTransition(invocation, this.cubeManager);
        return new ChangeToDimensionColumn(invocation, this.cubeManager, this.connectionProvider);
    }

    @Override
    protected ColumnType getManagedColumnType() {
        return MANAGED_COLUMN_TYPE;
    }

    protected List<Parameter> getParameters() {
        return parameters;
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    public List<WorkerFactory> getPrecoditionValidations() {
        return Arrays.asList(new WorkerFactory[]{this.validationFactory});
    }

    @Override
    protected List<ColumnType> getAllowedSourceColumnTypes() {
        return allowedSourceColumnTypes;
    }
}

