/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.column;

import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.List;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableCreator;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.factories.TimeDimensionColumnFactory;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.time.PeriodType;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.time.PeriodTypeHelper;
import org.gcube.data.analysis.tabulardata.operation.time.PeriodTypeHelperProvider;
import org.gcube.data.analysis.tabulardata.operation.validation.TimeDimensionColumnValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeToTimeDimensionColumn
extends Worker {
    private static final Logger log = LoggerFactory.getLogger(ChangeToTimeDimensionColumn.class);
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private Table targetTable;
    private Column targetColumn;
    private PeriodType periodType;
    private Table newTable;
    private Table timeCodelist;
    private PeriodTypeHelperProvider periodTypeHelperProvider;
    private Column timeDimensionColumn;

    public ChangeToTimeDimensionColumn(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, PeriodTypeHelperProvider periodTypeHelperProvider) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.periodTypeHelperProvider = periodTypeHelperProvider;
    }

    protected WorkerResult execute() throws WorkerException {
        this.retrieveParameters();
        this.updateProgress(0.1f);
        this.createTimeCodelist();
        this.updateProgress(0.3f);
        this.createNewTable();
        this.updateProgress(0.6f);
        this.linkNewTableToTimeCodelist();
        return new ImmutableWorkerResult(this.newTable, (List)Lists.newArrayList((Object[])new Table[]{this.timeCodelist}));
    }

    private void linkNewTableToTimeCodelist() throws WorkerException {
        PeriodTypeHelper helper = this.periodTypeHelperProvider.getHelper(this.periodType);
        String sql = helper.getUpdateDimensionColumnSQL(this.targetTable.getName(), this.targetColumn.getName(), this.newTable.getName(), this.timeDimensionColumn.getName(), this.timeCodelist.getName());
        try {
            SQLHelper.executeSQLCommand(sql, this.connectionProvider);
        }
        catch (SQLException e) {
            throw new WorkerException("Unable to link target table tuples to the newly created time codelist", (Throwable)e);
        }
    }

    private void createNewTable() {
        this.timeDimensionColumn = new TimeDimensionColumnFactory().create(this.periodType);
        TableCreator tableCreator = this.cubeManager.createTable(this.targetTable.getTableType());
        tableCreator.like(this.targetTable, true, (List)Lists.newArrayList((Object[])new Column[]{this.targetColumn}));
        tableCreator.addColumn(this.timeDimensionColumn);
        this.newTable = tableCreator.create();
    }

    private void createTimeCodelist() throws WorkerException {
        PeriodTypeHelper helper = this.periodTypeHelperProvider.getHelper(this.periodType);
        this.timeCodelist = helper.createTimeCodelist();
        String fillTimeCodelistSQL = helper.getFillTimeCodelistSQL(this.targetTable.getName(), this.targetColumn.getName(), this.timeCodelist.getName());
        try {
            SQLHelper.executeSQLCommand(fillTimeCodelistSQL, this.connectionProvider);
        }
        catch (SQLException e) {
            String msg = "An error occurred while filling the time dimension table, data is probably not suited for the operation";
            log.error(msg);
            throw new WorkerException(msg);
        }
    }

    private void retrieveParameters() {
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        this.targetColumn = this.targetTable.getColumnById(this.getSourceInvocation().getTargetColumnId());
        String periodTypeName = (String)OperationHelper.getParameter(TimeDimensionColumnValidatorFactory.PERIOD_FORMAT_PARAMETER, this.getSourceInvocation());
        this.periodType = PeriodType.fromName((String)periodTypeName);
    }
}

