/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.time;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.time.PeriodType;
import org.gcube.data.analysis.tabulardata.operation.time.PeriodTypeHelper;

@Singleton
public class YearHelper
implements PeriodTypeHelper {
    @Inject
    CubeManager cubeManager;

    @Override
    public String getFillValidationColumnSQL(String validationTableName, String validationColumnName, String targetColumnName) {
        return String.format("UPDATE %s SET %s = is_valid_year(%s)", validationTableName, validationColumnName, targetColumnName);
    }

    @Override
    public PeriodType getManagedPeriodType() {
        return PeriodType.YEAR;
    }

    @Override
    public Table createTimeCodelist() {
        return this.cubeManager.createTimeCodelist(PeriodType.YEAR);
    }

    @Override
    public String getColumnName() {
        return "year_code";
    }

    @Override
    public String getFillTimeCodelistSQL(String targetTableName, String targetColumnName, String timeTableName) {
        return String.format("INSERT INTO %s ( year_code ) SELECT DISTINCT(normalize_year(%s)) FROM %s;", timeTableName, targetColumnName, targetTableName);
    }

    @Override
    public String getUpdateDimensionColumnSQL(String targetTableName, String targetColumnName, String newTableName, String timeDimensionColumnName, String timeTableName) {
        return String.format("WITH id_codes AS (\tSELECT original.id AS tuple_id, time_codelist.id AS time_id, year_code \tFROM %1$s AS original JOIN %2$s AS time_codelist ON ( normalize_year(%3$s) = year_code )) UPDATE %4$s SET %5$s = (SELECT time_id FROM id_codes WHERE %4$s.id = id_codes.tuple_id);", targetTableName, timeTableName, targetColumnName, newTableName, timeDimensionColumnName);
    }
}

