/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableMetaCreator;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.DimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.MeasureColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.TimeDimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.Validation;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ValidationsMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.type.DatasetTableType;
import org.gcube.data.analysis.tabulardata.operation.EmptyType;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ValidationWorker;

public class ValidateDataset
extends ValidationWorker {
    private CubeManager cube;
    private List<ColumnType> allowedColumnTypes = new DatasetTableType().getAllowedColumnTypes();
    private HashMap<ColumnLocalId, List<Validation>> validationMap = new HashMap();
    Table targetTable;

    public ValidateDataset(OperationInvocation sourceInvocation, CubeManager cube) {
        super(sourceInvocation);
        this.cube = cube;
    }

    protected EmptyType execute() throws WorkerException {
        Table targetTable = this.cube.getTable(this.getSourceInvocation().getTargetTableId());
        this.updateProgress(0.1f, "Checking allowed column types");
        boolean allowedGlobalValid = true;
        for (Column col : targetTable.getColumns()) {
            boolean allowed = this.allowedColumnTypes.contains(col.getColumnType());
            if (!allowed) {
                allowedGlobalValid = false;
            }
            this.addValidation(col, new Validation("Allowed column type ", allowed));
        }
        Validation allowed = new Validation("Allowed column types", allowedGlobalValid);
        this.updateProgress(0.5f, "Checking mandatory columns");
        boolean mandatoryDimension = targetTable.getColumnsByType(new Class[]{TimeDimensionColumnType.class, DimensionColumnType.class}).size() > 0;
        Validation mandatoryDim = new Validation("Must contain at least one Dimension", mandatoryDimension);
        boolean mandatoryMeasure = targetTable.getColumnsByType(new Class[]{MeasureColumnType.class}).size() > 0;
        Validation mandatoryMeas = new Validation("Must contain at least one Measure", mandatoryMeasure);
        this.updateProgress(0.8f, "Finalizing validations");
        TableMetaCreator creator = this.cube.modifyTableMeta(targetTable.getId());
        for (Map.Entry<ColumnLocalId, List<Validation>> entry : this.validationMap.entrySet()) {
            creator.setColumnMetadata(entry.getKey(), new ColumnMetadata[]{new ValidationsMetadata(entry.getValue())});
        }
        creator.setTableMetadata(new TableMetadata[]{new ValidationsMetadata(Arrays.asList(allowed, mandatoryDim, mandatoryMeas))});
        creator.create();
        return EmptyType.instance();
    }

    private void addValidation(Column col, Validation toAdd) {
        if (!this.validationMap.containsKey(col.getLocalId())) {
            ArrayList validations = new ArrayList();
            try {
                validations.addAll(((ValidationsMetadata)col.getMetadata(ValidationsMetadata.class)).getValidations());
            }
            catch (NoSuchMetadataException e) {
                // empty catch block
            }
            this.validationMap.put(col.getLocalId(), validations);
        }
        this.validationMap.get(col.getLocalId()).add(toAdd);
    }
}

