/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.MultivaluedExpression;
import org.gcube.data.analysis.tabulardata.expression.composite.ExternalReferenceExpression;
import org.gcube.data.analysis.tabulardata.expression.evaluator.description.DescriptionExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.expression.leaf.LeafExpression;
import org.gcube.data.analysis.tabulardata.expression.logical.ValueIsIn;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDBoolean;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.type.CodelistTableType;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.factories.types.ColumnValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.ExpressionParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.TargetColumnParameter;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateDataWithExpression;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateDataWithExpressionFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ValidationWorker;

@Singleton
public class ValidateDimensionColumnFactory
extends ColumnValidatorFactory {
    private static final OperationId OPERATION_ID = new OperationId(5010L);
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private SQLExpressionEvaluatorFactory sqlEvaluatorFactory;
    private DescriptionExpressionEvaluatorFactory descriptionEvaluatorFactory;
    public static TargetColumnParameter TARGET_COLUMN_PARAMETER;
    public static ExpressionParameter EXTERNAL_CONDITION_PARAMETER;
    private static List<Parameter> parameters;

    protected String getOperationName() {
        return "Dimension Column Validator";
    }

    protected String getOperationDescription() {
        return "Validate the specified dimension column";
    }

    protected List<Parameter> getParameters() {
        return parameters;
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    @Inject
    public ValidateDimensionColumnFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory sqlEvaluatorFactory, DescriptionExpressionEvaluatorFactory descriptionEvaluatorFactory) {
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.sqlEvaluatorFactory = sqlEvaluatorFactory;
        this.descriptionEvaluatorFactory = descriptionEvaluatorFactory;
    }

    public ValidationWorker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        Expression toCheck = ValidateDimensionColumnFactory.generateValidationExpression(invocation);
        invocation.getParameterInstances().put(ValidateDataWithExpressionFactory.EXPRESSION_PARAMETER.getIdentifier(), toCheck);
        invocation.getParameterInstances().put(ValidateDataWithExpressionFactory.DESCRIPTION_PARAMETER.getIdentifier(), "External reference check");
        return new ValidateDataWithExpression(invocation, this.cubeManager, this.connectionProvider, this.sqlEvaluatorFactory, this.descriptionEvaluatorFactory);
    }

    public static Expression generateValidationExpression(OperationInvocation invocation) throws InvalidInvocationException {
        try {
            Map params = invocation.getParameterInstances();
            ColumnReference referredColumn = (ColumnReference)params.get(TARGET_COLUMN_PARAMETER.getIdentifier());
            Object optionalCondition = null;
            optionalCondition = params.containsKey(EXTERNAL_CONDITION_PARAMETER.getIdentifier()) ? (Expression)params.get(EXTERNAL_CONDITION_PARAMETER.getIdentifier()) : new TDBoolean(true);
            ExternalReferenceExpression externalRef = new ExternalReferenceExpression((LeafExpression)referredColumn, (Expression)optionalCondition);
            ColumnReference targetReference = new ColumnReference(invocation.getTargetTableId(), invocation.getTargetColumnId());
            return new ValueIsIn((Expression)targetReference, (MultivaluedExpression)externalRef);
        }
        catch (Exception e) {
            throw new InvalidInvocationException(invocation, "Unable to generate validation expression", e);
        }
    }

    public String describeInvocation(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        ColumnReference codelistRef = (ColumnReference)OperationHelper.getParameter((LeafParameter)TARGET_COLUMN_PARAMETER, (OperationInvocation)invocation);
        Table codelist = this.cubeManager.getTable(codelistRef.getTableId());
        Column col = codelist.getColumnById(codelistRef.getColumnId());
        Column targetColumn = this.cubeManager.getTable(invocation.getTargetTableId()).getColumnById(invocation.getTargetColumnId());
        return String.format("Check if values in %s are present in %s.%s [%s]", OperationHelper.retrieveColumnLabel((Column)targetColumn), OperationHelper.retrieveTableLabel((Table)codelist), OperationHelper.retrieveColumnLabel((Column)col), col.getColumnType().getName());
    }

    static {
        EXTERNAL_CONDITION_PARAMETER = new ExpressionParameter("expression", "Expression", "Condition on codelist values", Cardinality.OPTIONAL);
        ArrayList<CodelistTableType> allowedTableTypes = new ArrayList<CodelistTableType>();
        allowedTableTypes.add(new CodelistTableType());
        TARGET_COLUMN_PARAMETER = new TargetColumnParameter("refColumn", "Codelist referenced column", "A codelist column containing values that are contained in the target column", Cardinality.ONE, allowedTableTypes);
        parameters = Arrays.asList(TARGET_COLUMN_PARAMETER, EXTERNAL_CONDITION_PARAMETER);
    }
}

