package org.gcube.data.analysis.tabulardata.operation.time;

import javax.inject.Inject;
import javax.inject.Singleton;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.time.PeriodType;

@Singleton
public class MonthHelper implements PeriodTypeHelper {

	@Inject
	private CubeManager cubeManager;

	@Override
	public String getFillValidationColumnSQL(String validationTableName, String validationColumnName,
			String targetColumnName) {
		return String.format("UPDATE %s SET %s = is_valid_month(%s)", validationTableName, validationColumnName,
				targetColumnName);
	}

	@Override
	public PeriodType getManagedPeriodType() {
		return PeriodType.MONTH;
	}

	@Override
	public Table createTimeCodelist() {
		return cubeManager.createTimeCodelist(PeriodType.MONTH);
	}

	
	
	@Override
	public String getColumnName() {
		return "month_code";
	}

	@Override
	public String getFillTimeCodelistSQL(String targetTableName, String targetColumnName, String timeTableName) {
		return String.format("INSERT INTO %s ( month_code ) SELECT DISTINCT(normalize_month(%s)) FROM %s;", timeTableName, 
				targetColumnName, targetTableName);
	}

	
	
	@Override
	public String getUpdateDimensionColumnSQL(String targetTableName, String targetColumnName, String newTableName,
			String timeDimensionColumnName, String timeTableName) {
		return String.format("" +
				"WITH id_codes AS (" +
				"	SELECT original.id AS tuple_id, time_codelist.id AS time_id, month_code " +
				"	FROM %1$s AS original JOIN %2$s AS time_codelist ON ( normalize_month(%3$s) = month_code )" +
				") " +
				"UPDATE %4$s " +
				"SET %5$s = (SELECT time_id FROM id_codes WHERE %4$s.id = id_codes.tuple_id);", 
				targetTableName, timeTableName, targetColumnName, newTableName, timeDimensionColumnName
				);
	}

}
