/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.validation;

import java.sql.SQLException;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.factories.ValidationColumnFactory;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataValidationMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ValidationReferencesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.table.GlobalDataValidationReportMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.time.PeriodType;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.ValidationHelper;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.time.PeriodTypeHelper;
import org.gcube.data.analysis.tabulardata.operation.time.PeriodTypeHelperProvider;
import org.gcube.data.analysis.tabulardata.operation.validation.TimeDimensionColumnValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ValidityResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ValidationWorker;

public class TimeDimensionColumnValidator
extends ValidationWorker {
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private Table targetTable;
    private Column targetColumn;
    private Column validationColumn;
    private String periodTypeName;
    private PeriodTypeHelperProvider periodTypeHelperProvider;
    private SQLExpressionEvaluatorFactory evaluatorFactory;

    public TimeDimensionColumnValidator(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, PeriodTypeHelperProvider periodTypeHelperProvider, SQLExpressionEvaluatorFactory factory) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.periodTypeHelperProvider = periodTypeHelperProvider;
        this.evaluatorFactory = factory;
    }

    protected ValidityResult execute() throws WorkerException {
        this.retrieveParameters();
        this.updateProgress(0.1f, "Configuring validation");
        this.createValidationTable();
        this.updateProgress(0.4f, "Validating rows");
        this.fillValidationTableWithValidationData();
        this.updateProgress(0.8f, "Evaluating result");
        return new ValidityResult(this.evaluateValidationResultAndUpdateTableMeta() == 0);
    }

    private int evaluateValidationResultAndUpdateTableMeta() throws WorkerException {
        try {
            int invalidCount = ValidationHelper.getErrorCount((DatabaseConnectionProvider)this.connectionProvider, (Table)this.targetTable, (Column)this.validationColumn, (SQLExpressionEvaluatorFactory)this.evaluatorFactory);
            GlobalDataValidationReportMetadata globalMeta = ValidationHelper.createDataValidationReport((Column)this.validationColumn);
            ValidationReferencesMetadata referencesMeta = new ValidationReferencesMetadata(new Column[]{this.targetColumn});
            this.targetTable = this.cubeManager.modifyTableMeta(this.targetTable.getId()).setColumnMetadata(this.validationColumn.getLocalId(), new ColumnMetadata[]{this.createDataValidationMetadata(invalidCount)}).setColumnMetadata(this.validationColumn.getLocalId(), new ColumnMetadata[]{referencesMeta}).setTableMetadata(new TableMetadata[]{globalMeta}).create();
            return invalidCount;
        }
        catch (Exception e) {
            throw new WorkerException("Unable to evaluate global validation", (Throwable)e);
        }
    }

    private void fillValidationTableWithValidationData() throws WorkerException {
        PeriodTypeHelper helper = this.periodTypeHelperProvider.getHelper(PeriodType.fromName((String)this.periodTypeName));
        try {
            SQLHelper.executeSQLCommand((String)helper.getFillValidationColumnSQL(this.targetTable.getName(), this.validationColumn.getName(), this.targetColumn.getName()), (DatabaseConnectionProvider)this.connectionProvider);
        }
        catch (SQLException e) {
            throw new WorkerException("Unable to evaluate validation condition on DB", (Throwable)e);
        }
    }

    private void createValidationTable() {
        this.validationColumn = this.createValidationColumn(0);
        this.targetTable = this.cubeManager.addValidations(this.targetTable.getId(), new Column[]{this.validationColumn});
    }

    private Column createValidationColumn(int count) {
        ImmutableLocalizedText name = new ImmutableLocalizedText(String.format("Is valid %s format?", this.periodTypeName));
        DataValidationMetadata dataValidationMetadata = this.createDataValidationMetadata(count);
        return new ValidationColumnFactory().create((LocalizedText)name, dataValidationMetadata);
    }

    private DataValidationMetadata createDataValidationMetadata(int count) {
        String descriptionText = String.format("Tells if %s is of valid %s format", OperationHelper.retrieveColumnLabel((Column)this.targetColumn), this.periodTypeName);
        ImmutableLocalizedText description = new ImmutableLocalizedText(descriptionText);
        return new DataValidationMetadata((LocalizedText)description, count);
    }

    private void retrieveParameters() {
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        this.targetColumn = this.targetTable.getColumnById(this.getSourceInvocation().getTargetColumnId());
        this.periodTypeName = (String)OperationHelper.getParameter((LeafParameter)TimeDimensionColumnValidatorFactory.PERIOD_FORMAT_PARAMETER, (OperationInvocation)this.getSourceInvocation());
    }
}

