/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.validation;

import java.sql.SQLException;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.factories.ValidationColumnFactory;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataValidationMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ValidationReferencesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.table.GlobalDataValidationReportMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.ValidationHelper;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateAmbiguousReferenceFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ValidityResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ValidationWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateAmbiguousReference
extends ValidationWorker {
    private static Logger logger = LoggerFactory.getLogger(ValidateAmbiguousReference.class);
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private Table targetTable;
    private Column targetColumn;
    private Column validationColumn;
    private Table externalTable;
    private Column externalColumn;
    private Map<Long, Long> mapping;
    private SQLExpressionEvaluatorFactory sqlEvaluatorFactory;
    private static Logger log = LoggerFactory.getLogger(ValidateAmbiguousReference.class);

    public ValidateAmbiguousReference(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory sqlEvaluatorFactory) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.sqlEvaluatorFactory = sqlEvaluatorFactory;
    }

    protected ValidityResult execute() throws WorkerException {
        this.retrieveParameters();
        this.updateProgress(0.1f, "Creating validation structure");
        this.addValidationColumn();
        this.updateProgress(0.4f, "Filling validation column");
        this.fillValidationColumn();
        this.updateProgress(0.7f, "Finalizing validation");
        return new ValidityResult(this.evaluateValidityAndUpdateTableMeta() == 0);
    }

    private void retrieveParameters() {
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        this.targetColumn = this.targetTable.getColumnById(this.getSourceInvocation().getTargetColumnId());
        log.debug("targetColumn is " + this.targetColumn);
        this.mapping = (Map)this.getSourceInvocation().getParameterInstances().get(ValidateAmbiguousReferenceFactory.MAPPING_PARAMETER.getIdentifier());
        ColumnReference externalReference = (ColumnReference)this.getSourceInvocation().getParameterInstances().get(ValidateAmbiguousReferenceFactory.TARGET_COLUMN_PARAMETER.getIdentifier());
        this.externalTable = this.cubeManager.getTable(externalReference.getTableId());
        this.externalColumn = this.externalTable.getColumnById(externalReference.getColumnId());
    }

    private int evaluateValidityAndUpdateTableMeta() throws WorkerException {
        try {
            int invalidCount = ValidationHelper.getErrorCount((DatabaseConnectionProvider)this.connectionProvider, (Table)this.targetTable, (Column)this.validationColumn, (SQLExpressionEvaluatorFactory)this.sqlEvaluatorFactory);
            GlobalDataValidationReportMetadata globalMeta = ValidationHelper.createDataValidationReport((Column)this.validationColumn);
            DataValidationMetadata validationMeta = new DataValidationMetadata((LocalizedText)new ImmutableLocalizedText("Ambiguous values on external reference validation"), invalidCount);
            this.targetTable = this.cubeManager.modifyTableMeta(this.targetTable.getId()).setColumnMetadata(this.validationColumn.getLocalId(), new ColumnMetadata[]{validationMeta}).setTableMetadata(new TableMetadata[]{globalMeta}).create();
            return invalidCount;
        }
        catch (Exception e) {
            throw new WorkerException("Unable to evaluate global validation", (Throwable)e);
        }
    }

    private String generateSetAllFalseSqlCommand() {
        return String.format("UPDATE %s SET %s = true;", this.targetTable.getName(), this.validationColumn.getName());
    }

    private void fillValidationColumn() throws WorkerException {
        try {
            SQLHelper.executeSQLBatchCommands((DatabaseConnectionProvider)this.connectionProvider, (String[])new String[]{this.generateSetAllFalseSqlCommand(), this.generateValidationSqlCommand()});
        }
        catch (SQLException e) {
            logger.error("error filling validation column", (Throwable)e.getNextException());
            System.out.println("----------------------------");
            e.printStackTrace();
            throw new WorkerException("Error occurred while executing SQL command", (Throwable)e.getNextException());
        }
    }

    private String generateValidationSqlCommand() throws WorkerException {
        try {
            String query;
            StringBuffer mappingFrom = new StringBuffer();
            if (this.mapping != null && !this.mapping.isEmpty()) {
                mappingFrom.append("(VALUES");
                for (Map.Entry<Long, Long> mapEntry : this.mapping.entrySet()) {
                    mappingFrom.append(" (").append(mapEntry.getKey()).append(",").append(mapEntry.getValue()).append("),");
                }
                mappingFrom.deleteCharAt(mappingFrom.lastIndexOf(","));
                mappingFrom.append(") AS mapping (key, value) ");
                String referenceQuery = String.format(" (SELECT %1$s as value , array_agg(id) AS ids,  count(*) AS count FROM %2$s GROUP BY %1$s) AS reference", this.externalColumn.getName(), this.externalTable.getName());
                query = String.format("  UPDATE %1$s SET %2$s = false FROM ( %1$s as alias LEFT JOIN %3$s ON reference.value = alias.%4$s ) as l LEFT JOIN %5$s ON l.id= mapping.key  WHERE l.id=%1$s.id AND (key is null OR NOT(ARRAY[mapping.value] <@ (ids)))  and count>1 ", this.targetTable.getName(), this.validationColumn.getName(), referenceQuery, this.targetColumn.getName(), mappingFrom.toString());
            } else {
                query = String.format("UPDATE %1$s SET %2$s = false FROM (SELECT %3$s as value , array_agg(id) AS ids,  count(*) AS count FROM %4$s GROUP BY %3$s) AS reference WHERE  (reference.value = %5$s AND count>1 ) ", this.targetTable.getName(), this.validationColumn.getName(), this.externalColumn.getName(), this.externalTable.getName(), this.targetColumn.getName());
            }
            return query;
        }
        catch (Exception e) {
            log.error("error updating validation column", (Throwable)e);
            throw new WorkerException("error updating validation column", (Throwable)e);
        }
    }

    private void addValidationColumn() throws WorkerException {
        DataValidationMetadata validationMeta = new DataValidationMetadata((LocalizedText)new ImmutableLocalizedText("Ambiguous values on external reference validation"), 0);
        this.validationColumn = new ValidationColumnFactory().create((LocalizedText)new ImmutableLocalizedText("Ambiguous values"), validationMeta);
        this.targetTable = this.cubeManager.addValidations(this.targetTable.getId(), new Column[]{this.validationColumn});
        log.debug("Added validation column:\n" + this.targetTable);
        ValidationReferencesMetadata meta = new ValidationReferencesMetadata(new Column[]{this.targetColumn});
        this.targetTable = this.cubeManager.modifyTableMeta(this.targetTable.getId()).setColumnMetadata(this.validationColumn.getLocalId(), new ColumnMetadata[]{meta}).create();
    }
}

