/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.factories.ValidationColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDBoolean;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDTypeValue;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataValidationMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ValidationReferencesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.Validation;
import org.gcube.data.analysis.tabulardata.model.metadata.table.GlobalDataValidationReportMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.ValidationHelper;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.validation.DuplicateRowValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ValidationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ValidityResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ValidationWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateRowValidator
extends ValidationWorker {
    private static final Logger log = LoggerFactory.getLogger(DuplicateRowValidator.class);
    CubeManager cubeManager;
    DatabaseConnectionProvider connectionProvider;
    SQLExpressionEvaluatorFactory evaluatorFactory;
    Table targetTable;
    Column validationColumn;
    List<Column> toCheckColumns = null;
    private ValidationDescriptor validationdescriptor;

    public DuplicateRowValidator(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory evaluatorFactory) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.evaluatorFactory = evaluatorFactory;
    }

    protected ValidityResult execute() throws WorkerException {
        this.retrieveTargetTable();
        this.updateProgress(0.2f, "Configuring validation");
        this.createNewTableWithValidationColumn();
        this.updateProgress(0.4f, "Validating rows");
        this.fillNewTableWithData();
        this.updateProgress(0.8f, "Evaluating result");
        return new ValidityResult(this.evaluateValidityAndUpdateTableMeta() == 0, Collections.singletonList(this.validationdescriptor));
    }

    private int evaluateValidityAndUpdateTableMeta() throws WorkerException {
        try {
            int invalidCount = ValidationHelper.getErrorCount((DatabaseConnectionProvider)this.connectionProvider, (Table)this.targetTable, (Column)this.validationColumn, (SQLExpressionEvaluatorFactory)this.evaluatorFactory);
            GlobalDataValidationReportMetadata globalMeta = ValidationHelper.createDataValidationReport((Column)this.validationColumn);
            this.targetTable = this.cubeManager.modifyTableMeta(this.targetTable.getId()).setColumnMetadata(this.validationColumn.getLocalId(), new ColumnMetadata[]{this.createDataValidationMetadata(invalidCount)}).setTableMetadata(new TableMetadata[]{globalMeta}).create();
            return invalidCount;
        }
        catch (Exception e) {
            throw new WorkerException("Unable to evaluate global validation", (Throwable)e);
        }
    }

    private void fillNewTableWithData() throws WorkerException {
        try {
            SQLHelper.executeSQLBatchCommands((DatabaseConnectionProvider)this.connectionProvider, (String[])new String[]{this.createSetDuplicateASFalse()});
        }
        catch (Exception e) {
            String msg = "Unable to perform SQL operation";
            log.error(msg, (Throwable)e);
            throw new WorkerException(msg);
        }
    }

    private String createSetDuplicateASFalse() {
        String columnNamesSnippet = OperationHelper.getColumnNamesSnippet(this.toCheckColumns);
        return String.format("WITH selid AS (SELECT array_agg(id) FROM (SELECT min(id) AS id FROM (SELECT DISTINCT id , %1$s AS md FROM %2$s ORDER BY id ) AS ext GROUP BY md ) as agg) UPDATE %2$s as target set %3$s=true  WHERE target.id =ANY ((SELECT * FROM selid)::Integer[]);", columnNamesSnippet.replaceAll(",", " || "), this.targetTable.getName(), this.validationColumn.getName());
    }

    private void createNewTableWithValidationColumn() {
        DataValidationMetadata dataValidationMetadata = this.createDataValidationMetadata(0);
        this.validationColumn = new ValidationColumnFactory().useDefaultValue((TDTypeValue)new TDBoolean(false)).create((LocalizedText)new ImmutableLocalizedText("Unique Column Set"), dataValidationMetadata);
        this.targetTable = this.cubeManager.addValidations(this.targetTable.getId(), new Column[]{this.validationColumn});
        ValidationReferencesMetadata referencesMetadata = new ValidationReferencesMetadata(this.toCheckColumns.toArray(new Column[this.toCheckColumns.size()]));
        this.targetTable = this.cubeManager.modifyTableMeta(this.targetTable.getId()).setColumnMetadata(this.validationColumn.getLocalId(), new ColumnMetadata[]{referencesMetadata}).create();
    }

    private DataValidationMetadata createDataValidationMetadata(int count) {
        String validationText = String.format("%s is unique", OperationHelper.getColumnLabelsSnippet(this.toCheckColumns));
        this.validationdescriptor = new ValidationDescriptor(count == 0, validationText, 101);
        return new DataValidationMetadata(new Validation(validationText, count == 0, 101), count);
    }

    private void retrieveTargetTable() {
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        if (this.getSourceInvocation().getParameterInstances().containsKey(DuplicateRowValidatorFactory.KEY.getIdentifier())) {
            this.toCheckColumns = new ArrayList<Column>();
            Object colParam = this.getSourceInvocation().getParameterInstances().get(DuplicateRowValidatorFactory.KEY.getIdentifier());
            if (colParam instanceof Iterable) {
                for (ColumnReference col : (Iterable)colParam) {
                    this.toCheckColumns.add(this.targetTable.getColumnById(col.getColumnId()));
                }
            } else {
                this.toCheckColumns.add(this.targetTable.getColumnById(((ColumnReference)colParam).getColumnId()));
            }
        } else {
            this.toCheckColumns = this.targetTable.getColumnsExceptTypes(new Class[]{IdColumnType.class, ValidationColumnType.class});
        }
    }
}

