package org.gcube.data.analysis.tabulardata.operation.time;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.time.PeriodType;

public abstract class PeriodTypeHelper {
	
	public abstract PeriodType getManagedPeriodType();
	
	private CubeManager cubeManager;

	public PeriodTypeHelper(CubeManager cubeManager) {
		this.cubeManager = cubeManager;
	}
	
	public final String getFillValidationColumnSQL(String validationTableName, String validationColumnName,
			String targetColumnName) {
		return String.format("UPDATE %1$s SET %2$s = true WHERE %3$s in (SELECT %4$s_code From %4$s) ", validationTableName, validationColumnName,
				targetColumnName, this.getManagedPeriodType().getName());
	}

	
	public Table createTimeCodelist(){
		return cubeManager.getTimeTable(getManagedPeriodType());
	}
	
	public String getUpdateDimensionColumnSQL(String targetColumnName, String newTableName, String timeDimensionColumnName,String timeTableName){
		return String
				.format("UPDATE %1$s AS new_table SET %2$s = refCol.id FROM (SELECT id,  %5$s_code as val FROM %3$s) as refCol"
						+ " WHERE refCol.val=normalize_%5$s(to_iso_%5$s(new_table.%4$s)) ;",
						newTableName, timeDimensionColumnName, timeTableName,
						targetColumnName, getManagedPeriodType().getName().toLowerCase());
				
	}
	
}
