/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.validation;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.model.table.type.CodelistTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.DatasetTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.HierarchicalCodelistTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.TimeCodelistTableType;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.factories.types.TableValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.MultivaluedStringParameter;
import org.gcube.data.analysis.tabulardata.operation.table.ChangeTableTypeFactory;
import org.gcube.data.analysis.tabulardata.operation.validation.CodelistValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateDatasetFactory;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateGenericFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ValidationWorker;

@Singleton
public class ValidateTableFactory
extends TableValidatorFactory {
    private static final OperationId OPERATION_ID = new OperationId(5011L);
    private static final List<Parameter> parameters = new ArrayList<Parameter>();
    @Inject
    private CubeManager cubeManager;
    @Inject
    private CodelistValidatorFactory codelistFactory;
    @Inject
    private ValidateDatasetFactory datasetFactory;
    @Inject
    private ValidateGenericFactory genericFactory;

    public ValidationWorker createWorker(OperationInvocation arg0) throws InvalidInvocationException {
        this.performBaseChecks(arg0, this.cubeManager);
        Table table = this.cubeManager.getTable(arg0.getTargetTableId());
        TableType type = table.getTableType();
        if (arg0.getParameterInstances().containsKey(ChangeTableTypeFactory.TABLE_TYPE_PARAMETER.getIdentifier())) {
            type = ChangeTableTypeFactory.getTableType((String)OperationHelper.getParameter((LeafParameter)ChangeTableTypeFactory.TABLE_TYPE_PARAMETER, (OperationInvocation)arg0));
        }
        if (type.equals((Object)new CodelistTableType()) || type.equals((Object)new HierarchicalCodelistTableType()) || type.equals((Object)new TimeCodelistTableType())) {
            return this.codelistFactory.createWorker(arg0);
        }
        if (type.equals((Object)new DatasetTableType())) {
            return this.datasetFactory.createWorker(arg0);
        }
        return this.genericFactory.createWorker(arg0);
    }

    protected String getOperationDescription() {
        return "Perform validations based on current table type";
    }

    protected String getOperationName() {
        return "Validate Table";
    }

    protected List<Parameter> getParameters() {
        return parameters;
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    public String describeInvocation(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        Table targetTable = this.cubeManager.getTable(invocation.getTargetTableId());
        TableType type = targetTable.getTableType();
        if (invocation.getParameterInstances().containsKey(ChangeTableTypeFactory.TABLE_TYPE_PARAMETER.getIdentifier())) {
            type = ChangeTableTypeFactory.getTableType((String)OperationHelper.getParameter((LeafParameter)ChangeTableTypeFactory.TABLE_TYPE_PARAMETER, (OperationInvocation)invocation));
        }
        return String.format("Check if %s is a valid %s.", OperationHelper.retrieveTableLabel((Table)targetTable), type.getName());
    }

    static {
        parameters.add((Parameter)new MultivaluedStringParameter(ChangeTableTypeFactory.TABLE_TYPE_PARAMETER.getIdentifier(), "tableType", "optional table type", Cardinality.OPTIONAL, ChangeTableTypeFactory.TABLE_TYPE_PARAMETER.getAdmittedValues()));
    }
}

