package org.gcube.data.analysis.tabulardata.operation.column.metadata;

import java.util.Collections;
import java.util.List;

import javax.inject.Inject;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.factories.types.ColumnMetadataWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.IntegerParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.MetadataWorker;

public class ChangeColumnPositionFactory extends ColumnMetadataWorkerFactory{

	public static final IntegerParameter NEW_POSIITON_PARAMETER= new IntegerParameter("position", "Position", "the new position for the column", Cardinality.ONE);
	
	CubeManager cubeManager;
	
	
	
	@Inject
	public ChangeColumnPositionFactory(CubeManager cubeManager) {
		this.cubeManager = cubeManager;
	}

	@Override
	public MetadataWorker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
		performBaseChecks(invocation,cubeManager);
		internalCheck(invocation);
		return new ChangeColumnPositionWorker(cubeManager, invocation);
	}	
		
	@Override
	protected OperationId getOperationId() {
		return new OperationId(1010);
	}

	@Override
	protected String getOperationName() {
		return "ChangeColumnPosition";
	}

	@Override
	protected String getOperationDescription() {
		return "Modifies the column position";
	}

	@Override
	protected List<Parameter> getParameters() {
		return Collections.singletonList((Parameter)NEW_POSIITON_PARAMETER);
	}
	
	private void internalCheck(OperationInvocation invocation) throws InvalidInvocationException{
		Table table = cubeManager.getTable(invocation.getTargetTableId());
		Integer position = (Integer) invocation.getParameterInstances().get(NEW_POSIITON_PARAMETER.getIdentifier());
		if (position<0 || position>= table.getColumns().size())
				throw new InvalidInvocationException(invocation, "new position is invalid");
	}
	

}
