/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.column;

import java.sql.SQLException;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableCreator;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.metadata.table.GenericMapMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.RollbackWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeTypeRollbackableWorker
extends RollbackWorker {
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private Logger logger = LoggerFactory.getLogger(ChangeTypeRollbackableWorker.class);
    protected static final String REFERENCE_COLUMN_KEY = "referenceColumn";

    public ChangeTypeRollbackableWorker(Table diffTable, Table resultTable, OperationInvocation oldInvocation, CubeManager cm, DatabaseConnectionProvider connectionProvider) {
        super(diffTable, resultTable, oldInvocation);
        this.cubeManager = cm;
        this.connectionProvider = connectionProvider;
    }

    protected WorkerResult execute() throws WorkerException {
        String tempColumnLocalId;
        Column oldColumn = this.getDifftablTable().contains(GenericMapMetadata.class) && (tempColumnLocalId = (String)((GenericMapMetadata)this.getDifftablTable().getMetadata(GenericMapMetadata.class)).getMetadataMap().get(REFERENCE_COLUMN_KEY)) != null ? this.getResultTable().getColumnById(new ColumnLocalId(tempColumnLocalId)) : this.getResultTable().getColumnById(this.getSourceInvocation().getTargetColumnId());
        Column newColumn = this.getDifftablTable().getColumnById(this.getSourceInvocation().getTargetColumnId());
        newColumn.removeAllMetadata();
        newColumn.setAllMetadata(oldColumn.getAllMetadata());
        this.updateProgress(0.1f, "creating result table");
        TableCreator tableCreator = this.cubeManager.createTable(this.getResultTable().getTableType()).like(this.getResultTable(), true).addColumnAfter(newColumn, oldColumn).removeColumn(oldColumn);
        Table tableToReturn = tableCreator.create();
        tableToReturn = this.cubeManager.modifyTableMeta(tableToReturn.getId()).removeAllTableMetadata().setTableMetadata(this.getDifftablTable().getAllMetadata().toArray(new TableMetadata[0])).create();
        this.updateProgress(0.6f, "merging result table with old data");
        String insertQuery = "UPDATE " + tableToReturn.getName() + " as returnTable SET " + newColumn.getName() + "= diffTable." + newColumn.getName() + " FROM " + this.getDifftablTable().getName() + " AS diffTable WHERE diffTable.id=returnTable.id";
        try {
            SQLHelper.executeSQLCommand((String)insertQuery, (DatabaseConnectionProvider)this.connectionProvider);
        }
        catch (SQLException e) {
            this.logger.error("error rollbacking " + this.getSourceInvocation(), (Throwable)e);
            throw new WorkerException("error rollbacking" + this.getSourceInvocation().getOperationDescriptor());
        }
        return new ImmutableWorkerResult(tableToReturn);
    }
}

