/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.column;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AnnotationColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeDescriptionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeNameColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.DimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.column.ChangeColumnTypeTransformationFactory;
import org.gcube.data.analysis.tabulardata.operation.column.ChangeToDimensionColumn;
import org.gcube.data.analysis.tabulardata.operation.column.ChangeTypeRollbackableWorker;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateAmbiguousReferenceFactory;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateDimensionColumnFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.types.RollbackWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ValidationWorker;

public class ChangeToDimensionColumnFactory
extends ChangeColumnTypeTransformationFactory {
    private static final ColumnType MANAGED_COLUMN_TYPE = new DimensionColumnType();
    private static final OperationId OPERATION_ID = new OperationId(2006L);
    private static final List<Parameter> parameters = new ArrayList<Parameter>();
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private SQLExpressionEvaluatorFactory evaluatorFactory;
    private ValidateDimensionColumnFactory validationFactory;
    private ValidateAmbiguousReferenceFactory ambiguousValidationfactory;
    private static final List<ColumnType> allowedSourceColumnTypes = Lists.newArrayList();

    @Inject
    public ChangeToDimensionColumnFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, ValidateDimensionColumnFactory validationFactory, ValidateAmbiguousReferenceFactory ambiguousValidationfactory, SQLExpressionEvaluatorFactory evaluatorFactory) {
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.validationFactory = validationFactory;
        this.ambiguousValidationfactory = ambiguousValidationfactory;
        this.evaluatorFactory = evaluatorFactory;
    }

    public DataWorker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        this.checkAllowedColumnTypeTransition(invocation, this.cubeManager);
        this.checkCodelistUnicity(invocation, this.cubeManager);
        return new ChangeToDimensionColumn(invocation, this.cubeManager, this.connectionProvider, this.evaluatorFactory);
    }

    private void checkCodelistUnicity(OperationInvocation invocation, CubeManager cubeManager) throws InvalidInvocationException {
        ColumnReference columnRef = (ColumnReference)OperationHelper.getParameter((LeafParameter)ValidateDimensionColumnFactory.TARGET_COLUMN_PARAMETER, (OperationInvocation)invocation);
        Table table = cubeManager.getTable(invocation.getTargetTableId());
        Column opColumn = table.getColumnById(invocation.getTargetColumnId());
        for (Column column : table.getColumnsByType(new Class[]{DimensionColumnType.class})) {
            if (!column.getRelationship().getTargetTableId().equals((Object)columnRef.getTableId()) || opColumn.getLocalId() == column.getLocalId()) continue;
            throw new InvalidInvocationException(invocation, "Codelist reference already present in the table (two different columns of a table cannot point to the same external table)");
        }
    }

    public boolean isRollbackable() {
        return true;
    }

    public RollbackWorker createRollbackWoker(Table diffTable, Table createdTable, OperationInvocation oldInvocation) {
        return new ChangeTypeRollbackableWorker(diffTable, createdTable, oldInvocation, this.cubeManager, this.connectionProvider);
    }

    @Override
    protected ColumnType getManagedColumnType() {
        return MANAGED_COLUMN_TYPE;
    }

    protected List<Parameter> getParameters() {
        return parameters;
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    public List<WorkerFactory<ValidationWorker>> getPrecoditionValidations() {
        return Arrays.asList(new WorkerFactory[]{this.validationFactory, this.ambiguousValidationfactory});
    }

    @Override
    protected List<ColumnType> getAllowedSourceColumnTypes() {
        return allowedSourceColumnTypes;
    }

    public String describeInvocation(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        this.checkAllowedColumnTypeTransition(invocation, this.cubeManager);
        ColumnReference codelistRef = (ColumnReference)OperationHelper.getParameter((LeafParameter)ValidateDimensionColumnFactory.TARGET_COLUMN_PARAMETER, (OperationInvocation)invocation);
        Table codelist = this.cubeManager.getTable(codelistRef.getTableId());
        Column col = codelist.getColumnById(codelistRef.getColumnId());
        Column targetColumn = this.cubeManager.getTable(invocation.getTargetTableId()).getColumnById(invocation.getTargetColumnId());
        return String.format("Set %s as Dimension, referring %s.%s [%s]", OperationHelper.retrieveColumnLabel((Column)targetColumn), OperationHelper.retrieveTableLabel((Table)codelist), OperationHelper.retrieveColumnLabel((Column)col), col.getColumnType().getName());
    }

    static {
        allowedSourceColumnTypes.add((ColumnType)new CodeColumnType());
        allowedSourceColumnTypes.add((ColumnType)new CodeNameColumnType());
        allowedSourceColumnTypes.add((ColumnType)new CodeDescriptionColumnType());
        allowedSourceColumnTypes.add((ColumnType)new AttributeColumnType());
        allowedSourceColumnTypes.add((ColumnType)new AnnotationColumnType());
        parameters.add((Parameter)ValidateDimensionColumnFactory.TARGET_COLUMN_PARAMETER);
        parameters.add((Parameter)ValidateDimensionColumnFactory.EXTERNAL_CONDITION_PARAMETER);
        parameters.add((Parameter)ValidateAmbiguousReferenceFactory.MAPPING_PARAMETER);
        parameters.add((Parameter)ADDITIONAL_META_PARAMETER);
    }
}

